/*
 * Copyright 2019, 2022, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * BAL MultiSocket Types Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phbalReg.h>

#ifndef PHBALREG_MULTISOCKET_TYPES_H
#define PHBALREG_MULTISOCKET_TYPES_H

/* ---------------- */
/* Type Definitions */
/* ---------------- */

typedef struct SendParams
{
	phbalReg_MultiSocket_DataParams_t * pDataParams;
	uint8_t * pTxBuffer;
	uint16_t wTxLength;
} SendParams_t;

typedef struct RecvParams
{
	phbalReg_MultiSocket_DataParams_t * pDataParams;
	uint16_t wRxBufferSize;
	uint8_t * pRxBuffer;
	uint16_t * pRxLength;
} RecvParams_t;

#endif /* PHBALREG_MULTISOCKET_TYPES_H */
