/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal FPGA BOX BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#pragma warning( disable : 4996 )
#include <ctype.h>
#include <cwchar>
#include <iostream>
/*#include <stdlib.h>
#include <stdio.h>              /* PRQA S 5124 */
#pragma warning(pop)            /* PRQA S 3116 */

#import "..\..\..\phhalHw\src\ProxiLAB\ex\ProxiLAB.exe" no_namespace

#ifdef NXPBUILD__PHBAL_REG_PROXILAB

#include "phbalReg_ProxiLAB_Int.h"
#include "..\..\..\phhalHw\src\ProxiLAB\phhalHw_ProxiLAB_Config.h"

phStatus_t phbalReg_ProxiLAB_Int_OpenPort(
                                      phbalReg_ProxiLAB_DataParams_t * pDataParams
                                      )
{
    IProxiLABPtr ProxiLAB;
    phStatus_t status;

    /* Create ProxiLAB object */
    HRESULT hr = ProxiLAB.CreateInstance("KEOLABS.ProxiLAB");

    if (FAILED(hr))
    {
        /* Failed to create COM object */
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);
    }

    /* Check if Reader is connected */
    if (!ProxiLAB->IsConnected)
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);
    }

    PH_CHECK_SUCCESS_FCT(status, phbalReg_ProxiLAB_Int_ConvertError(pDataParams, ProxiLAB, ProxiLAB->Settings->LoadDefaultConfig()));
    PH_CHECK_SUCCESS_FCT(status, phbalReg_ProxiLAB_Int_ApplicationNeedsRecompiling(pDataParams, ProxiLAB));

    pDataParams->bIsBetaVersion = (ProxiLAB->IsBetaVersion() != 0) ? PH_ON : PH_OFF;
    pDataParams->bBoardRevision = ProxiLAB->BoardRevision;
    strcpy_s((char *)pDataParams->bHardwareVersion, PHBAL_REG_PROXILAB_VERSION_SIZE, (char *)ProxiLAB->HardwareVersion);
    strcpy_s((char *)pDataParams->bFirmwareVersion, PHBAL_REG_PROXILAB_VERSION_SIZE, (char *)ProxiLAB->FirmwareVersion);
    strcpy_s((char *)pDataParams->bSoftwareVersion, PHBAL_REG_PROXILAB_VERSION_SIZE, (char *)ProxiLAB->SoftwareVersion);
    strcpy_s((char *)pDataParams->bProxiLABSerial, PHBAL_REG_PROXILAB_VERSION_SIZE, (char *)ProxiLAB->ProxiLABSerial);
    pDataParams->bHardwareVersion[PHBAL_REG_PROXILAB_VERSION_SIZE-1] = 0;
    pDataParams->bFirmwareVersion[PHBAL_REG_PROXILAB_VERSION_SIZE-1] = 0;
    pDataParams->bSoftwareVersion[PHBAL_REG_PROXILAB_VERSION_SIZE-1] = 0;
    pDataParams->bProxiLABSerial[PHBAL_REG_PROXILAB_VERSION_SIZE-1] = 0;

    /* Pass IProxi to pDataParams Pointer */
    pDataParams->pProxiLAB = ProxiLAB;
    ProxiLAB.AddRef();

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_ProxiLAB_Int_ClosePort(
                                      phbalReg_ProxiLAB_DataParams_t * pDataParams
                                      )
{
    /* Release the IProxiLAB Smart Pointer */
    IProxiLABPtr ProxiLAB = (IProxiLAB*)pDataParams->pProxiLAB;
    ProxiLAB.Release();

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_ProxiLAB_Int_ConvertError(phbalReg_ProxiLAB_DataParams_t * pDataParams,
                                              void* pProxiLAB, uint32_t status)
{
    phStatus_t convertedStatus;
    IProxiLABPtr ProxiLAB = (IProxiLAB*)pProxiLAB;
    if (status == ERR_SUCCESSFUL)
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }

    switch(status)
    {
    case XSMRDR_ERR_CRC:
    case XSMRDR_ERR_PARITY:
        convertedStatus = PH_ADD_COMPCODE(PH_ERR_INTEGRITY_ERROR, PH_COMP_BAL);
        break;
    case XSMRDR_ERR_TIMEOUT:
        convertedStatus = PH_ADD_COMPCODE(PH_ERR_IO_TIMEOUT, PH_COMP_BAL);
        break;
    default:
        convertedStatus = PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);
        break;
    }

    /* Store the error message */
    sprintf_s((char *)pDataParams->bLastErrorMessage, PHBAL_REG_PROXILAB_ERROR_MESSAGE_SIZE, (char *)ProxiLAB->GetErrorInfo(status));
    return convertedStatus;
}

//This method should be called at the start of any application importing the type
//library ProxiLAB, to check if recompiling is required.
phStatus_t phbalReg_ProxiLAB_Int_ApplicationNeedsRecompiling(phbalReg_ProxiLAB_DataParams_t * pDataParams, void* pProxiLAB)
{
    uint8_t aBufferIn[16] = {
        0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
        0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF};
    uint8_t aBufferOut[16];
    unsigned long dwBufferOutSize;
    uint32_t dwRet;

    IProxiLABPtr ProxiLAB = (IProxiLAB*)pProxiLAB;

    /*Send the table to the server, get it back and check they are identical*/
    dwRet = ProxiLAB->EchoArray(aBufferIn, 16, aBufferOut, 16, &dwBufferOutSize);
    if (dwRet)
    {
        /*An error occurred (usually a bad parameter, this should not happen*/
        return phbalReg_ProxiLAB_Int_ConvertError(pDataParams, pProxiLAB, dwRet);
    }

    if (dwBufferOutSize != 16)
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);

    /*The EchoArray method returned an array: compare results*/
    for(int i = 0; i < 16; i++)
    {
        if(aBufferIn[i] != aBufferOut[i])
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */
