/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for RD710Sam BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_RD710SAM_INT_H
#define PHBALREG_RD710SAM_INT_H

#include <ph_Status.h>

#define PHBAL_RD710SAM_CMD_ACTIVATE_CONTACT_CARD    0x8001U
#define PHBAL_RD710SAM_CMD_DEACTIVATE_CONTACT_CARD  0x8006U
#define PHBAL_RD710SAM_CMD_CC_TRANSMIT_DATA         0x8008U
#define PHBAL_RD710SAM_CMD_CC_SEND_PPS              0x8009U
#define PHBAL_RD710SAM_CMD_RD_OPS_SET_PCSC_MODE		0xA00DU	/**< PCSC mode: Standard (0x00) or Direct (0x01). */

#define PHBAL_RD710SAM_FRAME_HEADER_LEN     6U  /**< Length of a command header. */
#define PHBAL_RD710SAM_FRAME_CMD_POS        0U  /**< Position of the command code (ushort). */
#define PHBAL_RD710SAM_FRAME_STATUS_POS     2U  /**< Position of the status (ushort). */
#define PHBAL_RD710SAM_FRAME_LEN_POS        4U  /**< Position of the length (ushort). */
#define PHBAL_RD710SAM_FRAME_PAYLOAD_POS    6U  /**< Position of the payload. */

phStatus_t phbalReg_Rd710Sam_CheckResponse(
    uint16_t wCmd,
    uint8_t * pRxBuffer,
    uint16_t wRxLength,
    uint8_t ** ppData,
    uint16_t * pDataLength
    );

phStatus_t phbalReg_Rd710Sam_ParseAtr(
    uint8_t * pAtr,
    uint16_t wAtrLenght,
    uint8_t * pTa1,
    uint8_t * pSpecificMode
    );

#endif /* PHBALREG_RD710SAM_INT_H */
