/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RDFPGA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_RDSCR01

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4200)           /* PRQA S 3116 */
#pragma warning(disable:4201)           /* PRQA S 3116 */
#include <windows.h>
#pragma warning(pop)                    /* PRQA S 3116 */

#include "phbalReg_RdScr01_Ex.h"


phStatus_t phbalReg_RdScr01_Ex_LoadFunctions(
                                             phbalReg_RdScr01_DataParams_t * pDataParams
                                             )
{
#ifdef _WIN32
    /* load library */
    pDataParams->pLibraryHandle = LoadLibrary(PHBAL_REG_RDSCR01_EX_DLL_NAME);

    /* check if loading succeded */
    if (pDataParams->pLibraryHandle == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    /* get all function pointers */
    pDataParams->pfInitVF = (PHBAL_REG_RDSCR01_INIT_VF) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_INIT_VF);
    if (pDataParams->pfInitVF == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfClose = (PHBAL_REG_RDSCR01_CLOSE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_CLOSE);
    if (pDataParams->pfClose == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSleep = (PHBAL_REG_RDSCR01_SLEEP) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_SLEEP);
    if (pDataParams->pfSleep == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRawSetBaudrate = (PHBAL_REG_RDSCR01_RAW_SET_BAUDRATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_RAW_SET_BAUDRATE);
    if (pDataParams->pfRawSetBaudrate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRawExchange = (PHBAL_REG_RDSCR01_RAW_EXCHANGE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_RAW_EXCHANGE);
    if (pDataParams->pfRawExchange == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRawGetColdAtr = (PHBAL_REG_RDSCR01_RAW_GETCOLDATR) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_RAW_GETCOLDATR);
    if (pDataParams->pfRawGetColdAtr == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRawGetWarmAtr = (PHBAL_REG_RDSCR01_RAW_GETWARMATR) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_RAW_GETWARMATR);
    if (pDataParams->pfRawGetWarmAtr == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSetVcc = (PHBAL_REG_RDSCR01_SET_VCC) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_SET_VCC);
    if (pDataParams->pfSetVcc == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSetUartFreq = (PHBAL_REG_RDSCR01_SET_UART_FREQENCY) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_SET_UART_FREQENCY);
    if (pDataParams->pfSetUartFreq == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816Activate = (PHBAL_REG_RDSCR01_7816_ACTIVATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_ISO7816_ACTIVATE);
    if (pDataParams->pf7816Activate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816Deactivate = (PHBAL_REG_RDSCR01_7816_DEACTIVATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_ISO7816_DEACTIVATE);
    if (pDataParams->pf7816Deactivate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816GetAtr = (PHBAL_REG_RDSCR01_7816_GETATR) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_ISO7816_GETATR);
    if (pDataParams->pf7816GetAtr == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816Exchange = (PHBAL_REG_RDSCR01_7816_EXCHANGE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_ISO7816_EXCHANGE);
    if (pDataParams->pf7816Exchange == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816ModifyProtocol = (PHBAL_REG_RDSCR01_7816_MODIFY_PROTOCOL) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_ISO7816_MODIFY_PROTOCOL);
    if (pDataParams->pf7816ModifyProtocol == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816ModifyTimeout = (PHBAL_REG_RDSCR01_7816_MODIFY_TIMEOUT) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_ISO7816_MODIFY_TIMEOUT);
    if (pDataParams->pf7816ModifyTimeout == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816GetFdt = (PHBAL_REG_RDSCR01_7816_GET_FDT) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_ISO7816_GET_FDT);
    if (pDataParams->pf7816GetFdt == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CSetControlByte = (PHBAL_REG_RDSCR01_I2C_SET_CONTROLBYTE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_I2C_SET_CONTROLBYTE);
    if (pDataParams->pfI2CSetControlByte == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSetIoConfig = (PHBAL_REG_RDSCR01_SET_IO_CONFIG) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_SET_IO_CONFIG);
    if (pDataParams->pfSetIoConfig == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CSendData = (PHBAL_REG_RDSCR01_I2C_SEND_DATA) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_I2C_SEND_DATA);
    if (pDataParams->pfI2CSendData == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CReadData = (PHBAL_REG_RDSCR01_I2C_READ_DATA) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_I2C_READ_DATA);
    if (pDataParams->pfI2CReadData == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CSetBitrate = (PHBAL_REG_RDSCR01_I2C_SET_BITRATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_I2C_SET_BITRATE);
    if (pDataParams->pfI2CSetBitrate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CSetParameter = (PHBAL_REG_RDSCR01_I2C_SET_PARAMETER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR01_EX_I2C_SET_PARAMETER);
    if (pDataParams->pfI2CSetParameter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

phStatus_t phbalReg_RdScr01_Ex_UnLoadFunctions(
                                               phbalReg_RdScr01_DataParams_t * pDataParams
                                               )
{
#ifdef _WIN32
    uint8_t bResult;

    /* check if the library is loaded */
    if (pDataParams->pLibraryHandle != NULL)
    {
        /* unload the library */
        bResult = (uint8_t)FreeLibrary((HMODULE)pDataParams->pLibraryHandle);

        /* check the success of the command */
        if (bResult == PH_OFF)
        {
            return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
        }

        /* set all function pointers to NULL */
        pDataParams->pfInitVF = NULL;
        pDataParams->pfClose = NULL;
        pDataParams->pfSleep = NULL;
        pDataParams->pfRawSetBaudrate = NULL;
        pDataParams->pfRawExchange = NULL;
        pDataParams->pfRawGetColdAtr = NULL;
        pDataParams->pfRawGetWarmAtr = NULL;
        pDataParams->pfSetUartFreq = NULL;
        pDataParams->pfSetVcc = NULL;
        pDataParams->pf7816Activate = NULL;
        pDataParams->pf7816Deactivate = NULL;
        pDataParams->pf7816Exchange = NULL;
        pDataParams->pf7816GetAtr = NULL;
        pDataParams->pf7816ModifyProtocol = NULL;
        pDataParams->pf7816ModifyTimeout = NULL;
        pDataParams->pf7816GetFdt = NULL;
        pDataParams->pfI2CSetControlByte = NULL;
        pDataParams->pfSetIoConfig = NULL;
        pDataParams->pfI2CSendData = NULL;
        pDataParams->pfI2CReadData = NULL;
        pDataParams->pfI2CSetBitrate = NULL;
        pDataParams->pfI2CSetParameter = NULL;

        /* set the handle to NULL */
        pDataParams->pLibraryHandle = NULL;
        /* return success */
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */
