/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RDFPGA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_RDSCR01_EX_H
#define PHBALREG_RDSCR01_EX_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_RdScr01_Ex_LoadFunctions(
                                             phbalReg_RdScr01_DataParams_t * pDataParams
                                             );

phStatus_t phbalReg_RdScr01_Ex_UnLoadFunctions(
                                               phbalReg_RdScr01_DataParams_t * pDataParams
                                               );

/* define the dll that has to be loaded */
#define PHBAL_REG_RDSCR01_EX_DLL_NAME                           "scr01_dll.dll"

/* define the function names that have to be loaded */
#define PHBAL_REG_RDSCR01_EX_INIT_VF                            "scr01_initialize_vf"
#define PHBAL_REG_RDSCR01_EX_CLOSE                              "scr01_close"
#define PHBAL_REG_RDSCR01_EX_SLEEP                              "scr01_hal_sleep"

#define PHBAL_REG_RDSCR01_EX_RAW_SET_BAUDRATE                   "scr01_raw_setbaudrate"
#define PHBAL_REG_RDSCR01_EX_RAW_EXCHANGE                       "scr01_raw_exchange"
#define PHBAL_REG_RDSCR01_EX_RAW_GETCOLDATR                     "scr01_get_cold_atr"
#define PHBAL_REG_RDSCR01_EX_RAW_GETWARMATR                     "scr01_get_warm_atr"

#define PHBAL_REG_RDSCR01_EX_SET_VCC                            "scr01_set_vcc"
#define PHBAL_REG_RDSCR01_EX_SET_UART_FREQENCY                  "scr01_set_uart_frequency"

#define PHBAL_REG_RDSCR01_EX_ISO7816_ACTIVATE                   "scr01_iso7816_activate"
#define PHBAL_REG_RDSCR01_EX_ISO7816_DEACTIVATE                 "scr01_iso7816_deactivate"
#define PHBAL_REG_RDSCR01_EX_ISO7816_GETATR                     "scr01_iso7816_getatr"
#define PHBAL_REG_RDSCR01_EX_ISO7816_EXCHANGE                   "scr01_iso7816_exchange"
#define PHBAL_REG_RDSCR01_EX_ISO7816_MODIFY_PROTOCOL            "scr01_iso7816_modify_protocol"
#define PHBAL_REG_RDSCR01_EX_ISO7816_MODIFY_TIMEOUT             "scr01_iso7816_modify_timeout"
#define PHBAL_REG_RDSCR01_EX_ISO7816_GET_FDT                    "scr01_iso7816_get_execution_time_us"

#define PHBAL_REG_RDSCR01_EX_I2C_SET_CONTROLBYTE                "scr01_rawi2c_set_controlbyte"
#define PHBAL_REG_RDSCR01_EX_SET_IO_CONFIG                      "scr01_set_io_configuration"
#define PHBAL_REG_RDSCR01_EX_I2C_SEND_DATA                      "scr01_rawi2c_send_data"
#define PHBAL_REG_RDSCR01_EX_I2C_READ_DATA                      "scr01_rawi2c_read_data2"
#define PHBAL_REG_RDSCR01_EX_I2C_SET_BITRATE                    "scr01_rawi2c_set_bitrate"
#define PHBAL_REG_RDSCR01_EX_I2C_SET_PARAMETER                  "scr01_rawi2c_set_parameter"

#endif /* PHBALREG_RDSCR01_EX_H */
