/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RS232 (Windows) BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_RDSCR01_H
#define PHBALREG_RDSCR01_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_RdScr01_GetPortList(
    phbalReg_RdScr01_DataParams_t * pDataParams,
    uint16_t wPortBufSize,
    uint8_t * pPortNames,
    uint16_t * pNumOfPorts
);

phStatus_t phbalReg_RdScr01_SetPort(
    phbalReg_RdScr01_DataParams_t * pDataParams,
    uint8_t * pPortName
);

phStatus_t phbalReg_RdScr01_OpenPort(
    phbalReg_RdScr01_DataParams_t * pDataParams
);

phStatus_t phbalReg_RdScr01_ClosePort(
    phbalReg_RdScr01_DataParams_t * pDataParams
);

phStatus_t phbalReg_RdScr01_Exchange(
    phbalReg_RdScr01_DataParams_t * pDataParams,
    uint16_t wOption,
    uint8_t * pTxBuffer,
    uint16_t wTxLength,
    uint16_t wRxBufSize,
    uint8_t * pRxBuffer,
    uint16_t * pRxLength
);

phStatus_t phbalReg_RdScr01_SetConfig(
    phbalReg_RdScr01_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint16_t wValue
);

phStatus_t phbalReg_RdScr01_GetConfig(
    phbalReg_RdScr01_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint16_t * pValue
);

#endif /* PHBALREG_RDSCR01_H */
