/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal FPGA BOX BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_RDSCR01

#include "phbalReg_RdScr01_Int.h"

typedef struct _FiDi_t
{
    uint32_t    br;
    uint8_t     fi;
    uint8_t     di;
} FiDi_t;

static const FiDi_t gFiDi_5Mhz[] =
{
    {   9600, 0x01, 0x01 },
    {  19200, 0x01, 0x02 },
    {  38400, 0x01, 0x03 },
    { 115200, 0x01, 0x08 }
};

phStatus_t phbalReg_RdScr01_Int_ConvertError(
                                             uint32_t status
                                             )
{
    switch (status)
    {
    case SCR01_OK:
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);

    case SCR01_E_INITIALIZE:
        return PH_ADD_COMPCODE(PH_ERR_IO_TIMEOUT, PH_COMP_BAL);

    case SCR01_E_DEVICEINFO :
    case SCR01_E_LOADFPGA:
    case SCR01_E_ALREADYINITIALIZED:
    case SCR01_E_WRITEREGISTER:
    case SCR01_E_NOTINITIALIZED:
    case SCR01_E_READREGISTER:
    case SCR01_E_DISPLAYWRONGPOSITION:
    case SCR01_E_DISPLAYWRONGLENGTH:
    case SCR01_E_WRITEINITDISPLAY:
    case SCR01_E_READEEPROMFILE:
    case SCR01_E_CORRUPTEEPROMFILE:
    case SCR01_E_WRONGEEPROMSIGNATURE:
    case SCR01_E_WRONGEEPROMCRC:
    case SCR01_E_DISPLAYCONTROL:
    case SCR01_E_SETSWITCH:
    case SCR01_E_CLEARSWITCH:
    case SCR01_E_SETTP1DIR:
    case SCR01_E_SETTP2DIR:
    case SCR01_E_SETTP1OUT:
    case SCR01_E_SETTP2OUT:
    case SCR01_E_CONTROLVOLTAGES:
    case SCR01_E_CONTROLIOPORTS:
    case SCR01_E_CONTROLCLOCKS:
    case SCR01_E_INITUART:
    case SCR01_E_SETBAUDRATE:
    case SCR01_E_SETCWT:
    case SCR01_E_SETBWT:
    case SCR01_E_GETCOLDATR:
    case SCR01_E_READBLOCK:
    case SCR01_E_WRITEBLOCK:
    case SCR01_E_WRITEBUFFER2MEMORY:
    case SCR01_E_RECEIVESTREAM:
    case SCR01_E_CLOSE:
    case SCR01_E_READFX2MEM:
    case SCR01_E_NOTSUPPORTEDHWVERSION:
    case SCR01_E_SERIALEECRCERROR:
    case SCR01_E_FATALERROR:
    case SCR01_E_PARAMERROR:
    case SCR01_E_GENERALHCIERROR:
    case SCR01_E_HCPNOFRAMERECEIVED:
    case SCR01_E_SETANTITEAR:
    case SCR01_E_RESETFPGA:
    case SCR01_E_NOREADERFOUND:
    case SCR01_E_SERIALNOTFOUND:
    case SCR01_E_OPENLOGFILEFAILED:
    case SCR01_E_FEATURENOTSUPPORTED:
    case SCR01_E_TRIGIDXNOTSUPP:
    case SCR01_E_LOGFILENOTOPEN:
    case SCR01_E_USERLOGTOOLONG:
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_BAL);

    default:
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_BAL);
    }
}

phStatus_t phbalReg_RdScr01_Int_SetBitRate(
                                           phbalReg_RdScr01_DataParams_t * pDataParams,
                                           uint32_t bitrate
                                           )
{
    phStatus_t statusTmp;
    FiDi_t *pFiDi = NULL;
    uint8_t i;

    for (i = 0; i < sizeof(gFiDi_5Mhz)/sizeof(gFiDi_5Mhz[0]); i++)
    {
        if (gFiDi_5Mhz[i].br == bitrate)
        {
            pFiDi = (FiDi_t *)&gFiDi_5Mhz[i];
            break;
        }
    }

    if (pFiDi != NULL)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_RdScr01_Int_ConvertError(pDataParams->pfRawSetBaudrate(pFiDi->fi, pFiDi->di)));
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_BAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */
