/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RDFPGA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_RDSCR2

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4200)           /* PRQA S 3116 */
#pragma warning(disable:4201)           /* PRQA S 3116 */
#include <windows.h>
#pragma warning(pop)                    /* PRQA S 3116 */

#include "phbalReg_RdScr2_Ex.h"


phStatus_t phbalReg_RdScr2_Ex_LoadFunctions(
                                             phbalReg_RdScr2_DataParams_t * pDataParams
                                             )
{
    DWORD dwLastError;
#ifdef _WIN32
    /* load library */
    pDataParams->pLibraryHandle = LoadLibrary(PHBAL_REG_RDSCR2_EX_DLL_NAME);
    dwLastError = GetLastError();

    /* check if loading succeded */
    if (pDataParams->pLibraryHandle == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    /* get all function pointers */
    pDataParams->pfEnumerate = (PHBAL_REG_RDSCR2_ENUMERATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ENUMERATE);
    if (pDataParams->pfEnumerate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfInit = (PHBAL_REG_RDSCR2_INIT) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_INIT);
    if (pDataParams->pfInit == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfClose = (PHBAL_REG_RDSCR2_CLOSE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_CLOSE);
    if (pDataParams->pfClose == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSleep = (PHBAL_REG_RDSCR2_SLEEP) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SLEEP);
    if (pDataParams->pfSleep == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816RawExchange = (PHBAL_REG_RDSCR2_ISO7816_RAW_EXCHANGE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_RAW_EXCHANGE);
    if (pDataParams->pf7816RawExchange == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816RawActivate = (PHBAL_REG_RDSCR2_ISO7816_RAW_ACTIVATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_RAW_ACTIVATE);
    if (pDataParams->pf7816RawActivate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816SetParameter = (PHBAL_REG_RDSCR2_ISO7816_SET_PARAMETER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_SET_PARAMETER);
    if (pDataParams->pf7816SetParameter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfControlIOPort = (PHBAL_REG_RDSCR2_CONTROL_IO_PORT) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_CONTROL_IO_PORT);
    if (pDataParams->pfControlIOPort == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSetVcc = (PHBAL_REG_RDSCR2_SET_VCC) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SET_VCC);
    if (pDataParams->pfSetVcc == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfPoweroffReset = (PHBAL_REG_RDSCR2_POWEROFF_RESET) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_POWEROFF_RESET);
    if (pDataParams->pfPoweroffReset == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816Activate = (PHBAL_REG_RDSCR2_ISO7816_ACTIVATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_ACTIVATE);
    if (pDataParams->pf7816Activate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816Deactivate = (PHBAL_REG_RDSCR2_ISO7816_DEACTIVATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_DEACTIVATE);
    if (pDataParams->pf7816Deactivate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816GetAtr = (PHBAL_REG_RDSCR2_ISO7816_GETATR) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_GETATR);
    if (pDataParams->pf7816GetAtr == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816Exchange = (PHBAL_REG_RDSCR2_ISO7816_EXCHANGE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_EXCHANGE);
    if (pDataParams->pf7816Exchange == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pf7816GetParameter = (PHBAL_REG_RDSCR2_ISO7816_GET_PARAMETER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_ISO7816_GET_PARAMETER);
    if (pDataParams->pf7816GetParameter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CSetSlaveParameter = (PHBAL_REG_RDSCR2_I2C_SET_SLAVE_PARAMETER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_I2C_SET_SLAVE_PARAMETER);
    if (pDataParams->pfI2CSetSlaveParameter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSetCommIfConfig = (PHBAL_REG_RDSCR2_SET_COMMIF_CONFIG) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SET_COMMIF_CONFIG);
    if (pDataParams->pfSetCommIfConfig == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CSendData = (PHBAL_REG_RDSCR2_I2C_SEND_DATA) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_I2C_SEND_DATA);
    if (pDataParams->pfI2CSendData == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CReadData = (PHBAL_REG_RDSCR2_I2C_READ_DATA) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_I2C_READ_DATA);
    if (pDataParams->pfI2CReadData == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfI2CSetParameter = (PHBAL_REG_RDSCR2_I2C_SET_PARAMETER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_I2C_SET_PARAMETER);
    if (pDataParams->pfI2CSetParameter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiSetParameter = (PHBAL_REG_RDSCR2_SPI_SET_PARAMETER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_SET_PARAMETER);
    if (pDataParams->pfSpiSetParameter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiGetParameter = (PHBAL_REG_RDSCR2_SPI_GET_PARAMETER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_GET_PARAMETER);
    if (pDataParams->pfSpiGetParameter == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiProtocolActivate = (PHBAL_REG_RDSCR2_SPI_PROTOCOL_ACTIVATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_PROTOCOL_ACTIVATE);
    if (pDataParams->pfSpiProtocolActivate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiProtocolDeactivate = (PHBAL_REG_RDSCR2_SPI_PROTOCOL_DEACTIVATE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_PROTOCOL_DEACTIVATE);
    if (pDataParams->pfSpiProtocolDeactivate == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiProtocolExchange = (PHBAL_REG_RDSCR2_SPI_PROTOCOL_EXCHANGE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_PROTOCOL_EXCHANGE);
    if (pDataParams->pfSpiProtocolExchange == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiRawExchange = (PHBAL_REG_RDSCR2_SPI_RAW_EXCHANGE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_RAW_EXCHANGE);
    if (pDataParams->pfSpiRawExchange == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiRawSend = (PHBAL_REG_RDSCR2_SPI_RAW_SEND) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_RAW_SEND);
    if (pDataParams->pfSpiRawSend == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfSpiRawRead = (PHBAL_REG_RDSCR2_SPI_RAW_READ) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_SPI_RAW_READ);
    if (pDataParams->pfSpiRawRead == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTriggerSetPort1 = (PHBAL_REG_RDSCR2_TRIGGER_SET_PORT1) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TRIGGER_SET_PORT1);
    if (pDataParams->pfTriggerSetPort1 == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTriggerSetPort2 = (PHBAL_REG_RDSCR2_TRIGGER_SET_PORT2) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TRIGGER_SET_PORT2);
    if (pDataParams->pfTriggerSetPort2 == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTriggerSetIccValue = (PHBAL_REG_RDSCR2_TRIGGER_SET_ICC_VALUE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TRIGGER_SET_ICC_VALUE);
    if (pDataParams->pfTriggerSetIccValue == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTriggerSetVtpValue = (PHBAL_REG_RDSCR2_TRIGGER_SET_VTP_VALUE) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TRIGGER_SET_VTP_VALUE);
    if (pDataParams->pfTriggerSetVtpValue == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTriggerSetHwInterfaceWait1 = (PHBAL_REG_RDSCR2_TRIGGER_SET_HW_INTERFACE_WAIT1) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TRIGGER_SET_HW_INTERFACE_WAIT1);
    if (pDataParams->pfTriggerSetHwInterfaceWait1 == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTriggerSetHwInterfaceWait2 = (PHBAL_REG_RDSCR2_TRIGGER_SET_HW_INTERFACE_WAIT2) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TRIGGER_SET_HW_INTERFACE_WAIT2);
    if (pDataParams->pfTriggerSetHwInterfaceWait2 == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTdaClearTriggers = (PHBAL_REG_RDSCR2_TDA_CLEAR_TRIGGERS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TDA_CLEAR_TRIGGERS);
    if (pDataParams->pfTdaClearTriggers == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTdaSetTrigger = (PHBAL_REG_RDSCR2_TDA_SET_TRIGGER) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TDA_SET_TRIGGER);
    if (pDataParams->pfTdaSetTrigger == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTdaStart = (PHBAL_REG_RDSCR2_TDA_START) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TDA_START);
    if (pDataParams->pfTdaStart == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTdaStop = (PHBAL_REG_RDSCR2_TDA_STOP) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TDA_STOP);
    if (pDataParams->pfTdaStop == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfTdaGetStatus = (PHBAL_REG_RDSCR2_TDA_GET_STATUS) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_TDA_GET_STATUS);
    if (pDataParams->pfTdaGetStatus == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfExtI2CEnabled = (PHBAL_REG_RDSCR2_EXTI2C_ENABLED) GetProcAddress((HMODULE)pDataParams->pLibraryHandle, PHBAL_REG_RDSCR2_EX_EXTI2C_ENABLED);
    if (pDataParams->pfExtI2CEnabled == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

phStatus_t phbalReg_RdScr2_Ex_UnLoadFunctions(
                                               phbalReg_RdScr2_DataParams_t * pDataParams
                                               )
{
#ifdef _WIN32
    uint8_t bResult;

    /* check if the library is loaded */
    if (pDataParams->pLibraryHandle != NULL)
    {
        /* unload the library */
        bResult = (uint8_t)FreeLibrary((HMODULE)pDataParams->pLibraryHandle);

        /* check the success of the command */
        if (bResult == PH_OFF)
        {
            return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
        }

        /* set all function pointers to NULL */
        pDataParams->pfEnumerate = NULL;
        pDataParams->pfInit = NULL;
        pDataParams->pfClose = NULL;
        pDataParams->pfSleep = NULL;
        pDataParams->pf7816RawExchange = NULL;
        pDataParams->pf7816RawActivate = NULL;
        pDataParams->pf7816SetParameter = NULL;
        pDataParams->pfControlIOPort = NULL;
        pDataParams->pfSetVcc = NULL;
        pDataParams->pfPoweroffReset = NULL;
        pDataParams->pf7816Activate = NULL;
        pDataParams->pf7816Deactivate = NULL;
        pDataParams->pf7816GetAtr = NULL;
        pDataParams->pf7816Exchange = NULL;
        pDataParams->pf7816GetParameter = NULL;
        pDataParams->pfI2CSetSlaveParameter = NULL;
        pDataParams->pfSetCommIfConfig = NULL;
        pDataParams->pfI2CSendData = NULL;
        pDataParams->pfI2CReadData = NULL;
        pDataParams->pfI2CSetParameter = NULL;
        pDataParams->pfSpiSetParameter = NULL;
        pDataParams->pfSpiGetParameter = NULL;
        pDataParams->pfSpiProtocolActivate = NULL;
        pDataParams->pfSpiProtocolDeactivate = NULL;
        pDataParams->pfSpiProtocolExchange = NULL;
        pDataParams->pfSpiRawExchange = NULL;
        pDataParams->pfSpiRawSend = NULL;
        pDataParams->pfSpiRawRead = NULL;
        pDataParams->pfTriggerSetPort1 = NULL;
        pDataParams->pfTriggerSetPort2 = NULL;
        pDataParams->pfTriggerSetIccValue = NULL;
        pDataParams->pfTriggerSetVtpValue = NULL;
        pDataParams->pfTriggerSetHwInterfaceWait1 = NULL;
        pDataParams->pfTriggerSetHwInterfaceWait2 = NULL;
        pDataParams->pfTdaClearTriggers = NULL;
        pDataParams->pfTdaSetTrigger = NULL;
        pDataParams->pfTdaStart = NULL;
        pDataParams->pfTdaStop = NULL;
        pDataParams->pfTdaGetStatus = NULL;
        pDataParams->pfExtI2CEnabled = NULL;

        /* set the handle to NULL */
        pDataParams->pLibraryHandle = NULL;
        /* return success */
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */
