/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PS6000USB BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef _WIN32
#include <string.h>
#endif

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE

#include "phbalReg_Smartware_Ex.h"

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4200)           /* PRQA S 3116 */
#pragma warning(disable:4201)           /* PRQA S 3116 */
#include <windows.h>
#pragma warning(pop)                    /* PRQA S 3116 */

phStatus_t phbalReg_Smartware_Ex_LoadFunctions(
    phbalReg_Smartware_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    /* load libraries */
    pDataParams->pLibraryHandleMlosCfg = LoadLibrary(PHBAL_REG_SMARTWARE_EX_DLL_MLOSCFG_NAME);
    pDataParams->pLibraryHandleCard = LoadLibrary(PHBAL_REG_SMARTWARE_EX_DLL_CARD_NAME);
    pDataParams->pLibraryHandleCardTm = LoadLibrary(PHBAL_REG_SMARTWARE_EX_DLL_CARDTM_NAME);
    pDataParams->pLibraryHandleCmt = LoadLibrary(PHBAL_REG_SMARTWARE_EX_DLL_CMT_NAME);

    /* check if loading succeded */
    if (pDataParams->pLibraryHandleMlosCfg == NULL || pDataParams->pLibraryHandleCard == NULL ||
        pDataParams->pLibraryHandleCardTm == NULL || pDataParams->pLibraryHandleCmt == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    /* get all function pointers */
    pDataParams->pfMlosCfgInit = (PHBAL_REG_SMARTWARE_MLOSCFG_INIT) GetProcAddress((HMODULE)pDataParams->pLibraryHandleMlosCfg, PHBAL_REG_SMARTWARE_EX_MLOSCFG_INIT);
    if (pDataParams->pfMlosCfgInit == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfMlosCfgStart = (PHBAL_REG_SMARTWARE_MLOSCFG_START) GetProcAddress((HMODULE)pDataParams->pLibraryHandleMlosCfg, PHBAL_REG_SMARTWARE_EX_MLOSCFG_START);
    if (pDataParams->pfMlosCfgStart == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfMlosCfgEnd = (PHBAL_REG_SMARTWARE_MLOSCFG_END) GetProcAddress((HMODULE)pDataParams->pLibraryHandleMlosCfg, PHBAL_REG_SMARTWARE_EX_MLOSCFG_END);
    if (pDataParams->pfMlosCfgEnd == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pfCardOpen = (PHBAL_REG_SMARTWARE_CARD_OPEN) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_OPEN);
    if (pDataParams->pfCardOpen == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardClose = (PHBAL_REG_SMARTWARE_CARD_CLOSE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_CLOSE);
    if (pDataParams->pfCardClose == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardReset = (PHBAL_REG_SMARTWARE_CARD_RESET) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_RESET);
    if (pDataParams->pfCardReset == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardResetWarm = (PHBAL_REG_SMARTWARE_CARD_RESET_WARM) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_RESET_WARM);
    if (pDataParams->pfCardResetWarm == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardOff = (PHBAL_REG_SMARTWARE_CARD_OFF) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_OFF);
    if (pDataParams->pfCardOff == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardSetClk = (PHBAL_REG_SMARTWARE_CARD_SET_CLK) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_SET_CLK);
    if (pDataParams->pfCardSetClk == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardSetVcc = (PHBAL_REG_SMARTWARE_CARD_SET_VCC) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_SET_VCC);
    if (pDataParams->pfCardSetVcc == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardSetFd = (PHBAL_REG_SMARTWARE_CARD_SET_FD) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_SET_FD);
    if (pDataParams->pfCardSetFd == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardSetGetConfig = (PHBAL_REG_SMARTWARE_CARD_SETGET_CONFIG) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_SETGET_CONFIG);
    if (pDataParams->pfCardSetGetConfig == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfCardExchange = (PHBAL_REG_SMARTWARE_CARD_EXCHANGE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleCard, PHBAL_REG_SMARTWARE_EX_CARD_EXCHANGE);
    if (pDataParams->pfCardExchange == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

phStatus_t phbalReg_Smartware_Ex_UnLoadFunctions(
    phbalReg_Smartware_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    uint8_t bResult;

    /* check if the library is loaded */
    if (pDataParams->pLibraryHandleMlosCfg != NULL)
    {
        /* unload the library */
        bResult = (uint8_t)FreeLibrary((HMODULE)pDataParams->pLibraryHandleMlosCfg);

        /* check the success of the command */
        if (bResult == PH_OFF)
        {
            return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
        }

        /* set all function pointers to NULL */
        pDataParams->pfMlosCfgInit              = NULL;
        pDataParams->pfMlosCfgStart             = NULL;
        pDataParams->pfMlosCfgEnd               = NULL;


        /* set the handle to NULL */
        pDataParams->pLibraryHandleMlosCfg = NULL;
        /* return success */
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
#else /* _WIN32 */
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */
