/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PS6000USB BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_SMARTWARE_EX_H
#define PHBALREG_SMARTWARE_EX_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_Smartware_Ex_LoadFunctions(
    phbalReg_Smartware_DataParams_t * pDataParams
    );

phStatus_t phbalReg_Smartware_Ex_UnLoadFunctions(
    phbalReg_Smartware_DataParams_t * pDataParams
    );

/* define the dll that has to be loaded */
#define PHBAL_REG_SMARTWARE_EX_DLL_MLOSCFG_NAME                 "MLOSMAIN.dll"
#define PHBAL_REG_SMARTWARE_EX_DLL_CARD_NAME                    "CARD.dll"
#define PHBAL_REG_SMARTWARE_EX_DLL_CARDTM_NAME                  "CARDTM.dll"
#define PHBAL_REG_SMARTWARE_EX_DLL_CMT_NAME                     "CMT.dll"

/* define the function names that have to be loaded */


/* MLOSMAIN API FUNCTIONS:*/
#define PHBAL_REG_SMARTWARE_EX_MLOSCFG_INIT                     "mloscfg_Init"
#define PHBAL_REG_SMARTWARE_EX_MLOSCFG_START                    "mloscfg_Start"
#define PHBAL_REG_SMARTWARE_EX_MLOSCFG_END                      "mloscfg_End"

#define PHBAL_REG_SMARTWARE_EX_CARD_OPEN                        "card_Open"
#define PHBAL_REG_SMARTWARE_EX_CARD_CLOSE                       "card_Close"
#define PHBAL_REG_SMARTWARE_EX_CARD_RESET                       "card_Reset"
#define PHBAL_REG_SMARTWARE_EX_CARD_RESET_WARM                  "card_ResetWarm"
#define PHBAL_REG_SMARTWARE_EX_CARD_OFF                         "card_Off"
#define PHBAL_REG_SMARTWARE_EX_CARD_SET_VCC                     "card_VccDef"
#define PHBAL_REG_SMARTWARE_EX_CARD_SET_CLK                     "card_FreqXDef"
#define PHBAL_REG_SMARTWARE_EX_CARD_SET_FD                      "card_FIDIDef"
#define PHBAL_REG_SMARTWARE_EX_CARD_SETGET_CONFIG               "card_CardCfgX"
#define PHBAL_REG_SMARTWARE_EX_CARD_EXCHANGE                    "card_TransceiveX"

#define PHBAL_REG_SMARTWARE_EX_CARDTM_INIT                      "cardtm_Init"
#define PHBAL_REG_SMARTWARE_EX_CMT_NEW                          "cmt_New"

#endif /* PHBALREG_SMARTWARE_EX_H */
