/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Amplifier AR75A250 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLAMP_AR75A250_H
#define PHDLAMP_AR75A250_H

#include <ph_Status.h>
#include <phdlAmp.h>

phStatus_t phdlAmp_AR75A250_SetPower(
                                     phdlAmp_AR75A250_DataParams_t * pDataParams,
                                     uint8_t bPowerOn
                                     );

phStatus_t phdlAmp_AR75A250_SetGain(
                                    phdlAmp_AR75A250_DataParams_t * pDataParams,
                                    uint16_t wGainValue
                                    );

phStatus_t phdlAmp_AR75A250_SetConfig(
                                      phdlAmp_AR75A250_DataParams_t * pDataParams,
                                      uint16_t wIdentifier,
                                      uint16_t wValue
                                      );

phStatus_t phdlAmp_AR75A250_GetConfig(
                                      phdlAmp_AR75A250_DataParams_t * pDataParams,
                                      uint16_t wIdentifier,
                                      uint16_t * pwValue
                                      );

#endif /* PHDLAMP_AR75A250_H */
