/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Amplifier MPRFA Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLAMP_MPRFA_INT_H
#define PHDLAMP_MPRFA_INT_H

#include <ph_Status.h>

phStatus_t phdlAmp_MPRFA_Int_GetHardwareInfoProperty(
    void *di, void *did,
    uint32_t dwProperty,
    uint8_t *pData,
    uint16_t wDataSize
    );

 #ifdef __cplusplus
 #define EXTERNC extern "C"
 #else
 #define EXTERNC
 #endif

EXTERNC phStatus_t phdlAmp_MPRFA_Int_CalcWaitTime(
    phdlAmp_MPRFA_DataParams_t * pDataParams,
    uint16_t wNewGain,
    uint16_t wMaxGain,
    uint16_t * wWaitTime
    );

EXTERNC phStatus_t phdlAmp_MPRFA_Int_GetVersion(
    phdlAmp_MPRFA_DataParams_t * pDataParams
    );

EXTERNC phStatus_t phdlAmp_MPRFA_Int_GetSerial(
    phdlAmp_MPRFA_DataParams_t * pDataParams
    );

EXTERNC phStatus_t phdlAmp_MPRFA_Int_ExchangeGetResp(
    phdlAmp_MPRFA_DataParams_t * pDataParams,
    uint8_t * pCommand,
    uint8_t * pResponse,
    uint16_t wRespSize,
    uint16_t * pwRxLen
    );

#undef EXTERNC

#endif /* PHDLAMP_MPRFA_INT_H */
