/*
 * Copyright 2013 - 2014, 2017, 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic Amplifier Device Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phdlAmp.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHDL_AMP_AR75A250
#include "AR75A250/phdlAmp_AR75A250.h"
#endif /* NXPBUILD__PHDL_AMP_AR75A250 */
#ifdef NXPBUILD__PHDL_AMP_BBA100
#include "BBA100/phdlAmp_BBA100.h"
#endif /* NXPBUILD__PHDL_AMP_BBA100 */
#ifdef NXPBUILD__PHDL_AMP_BBA150
#include "BBA150/phdlAmp_BBA150.h"
#endif /* NXPBUILD__PHDL_AMP_BBA150 */
#ifdef NXPBUILD__PHDL_AMP_MPRFA
#include "MPRFA/phdlAmp_MPRFA.h"
#endif /* NXPBUILD__PHDL_AMP_MPRFA */

#ifdef NXPBUILD__PHDL_AMP

phStatus_t phdlAmp_SetPower(
                            void * pDataParams,
                            uint8_t bPowerOn
                            )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlAmp_SetPower");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bPowerOn);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
	PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bPowerOn_log, &bPowerOn);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
	PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_AMP)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_AMP_AR75A250
    case PHDL_AMP_AR75A250_ID:
        status = phdlAmp_AR75A250_SetPower((phdlAmp_AR75A250_DataParams_t *)pDataParams, bPowerOn);
        break;
#endif /* NXPBUILD__PHDL_AMP_AR75A250 */
#ifdef NXPBUILD__PHDL_AMP_BBA100
    case PHDL_AMP_BBA100_ID:
        status = phdlAmp_BBA100_SetPower((phdlAmp_BBA100_DataParams_t *)pDataParams, bPowerOn);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA100 */
#ifdef NXPBUILD__PHDL_AMP_BBA150
    case PHDL_AMP_BBA150_ID:
        status = phdlAmp_BBA150_SetPower((phdlAmp_BBA150_DataParams_t *)pDataParams, bPowerOn);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA150 */
#ifdef NXPBUILD__PHDL_AMP_MPRFA
    case PHDL_AMP_MPRFA_ID:
        status = phdlAmp_MPRFA_SetPower((phdlAmp_MPRFA_DataParams_t *)pDataParams, bPowerOn);
        break;
#endif /* NXPBUILD__PHDL_AMP_MPRFA */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phdlAmp_SetGain(
                           void * pDataParams,
                           uint16_t wGainValue
                           )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlAmp_SetGain");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wGainValue);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wGainValue_log, &wGainValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
	PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_AMP)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_AMP_AR75A250
    case PHDL_AMP_AR75A250_ID:
        status = phdlAmp_AR75A250_SetGain((phdlAmp_AR75A250_DataParams_t *)pDataParams, wGainValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_AR75A250 */
#ifdef NXPBUILD__PHDL_AMP_BBA100
    case PHDL_AMP_BBA100_ID:
        status = phdlAmp_BBA100_SetGain((phdlAmp_BBA100_DataParams_t *)pDataParams, wGainValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA100 */
#ifdef NXPBUILD__PHDL_AMP_BBA150
    case PHDL_AMP_BBA150_ID:
        status = phdlAmp_BBA150_SetGain((phdlAmp_BBA150_DataParams_t *)pDataParams, wGainValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA150 */
#ifdef NXPBUILD__PHDL_AMP_MPRFA
    case PHDL_AMP_MPRFA_ID:
        status = phdlAmp_MPRFA_SetGain((phdlAmp_MPRFA_DataParams_t *)pDataParams, wGainValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_MPRFA */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phdlAmp_SetConfig(
                             void * pDataParams,
                             uint16_t wIdentifier,
                             uint16_t wValue
                             )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlAmp_SetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wIdentifier);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wValue);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wIdentifier_log, &wIdentifier);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wValue_log, &wValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_AMP)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_AMP_AR75A250
    case PHDL_AMP_AR75A250_ID:
        status = phdlAmp_AR75A250_SetConfig((phdlAmp_AR75A250_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_AR75A250 */
#ifdef NXPBUILD__PHDL_AMP_BBA100
    case PHDL_AMP_BBA100_ID:
        status = phdlAmp_BBA100_SetConfig((phdlAmp_BBA100_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA100 */
#ifdef NXPBUILD__PHDL_AMP_BBA150
    case PHDL_AMP_BBA150_ID:
        status = phdlAmp_BBA150_SetConfig((phdlAmp_BBA150_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA150 */
#ifdef NXPBUILD__PHDL_AMP_MPRFA
    case PHDL_AMP_MPRFA_ID:
        status = phdlAmp_MPRFA_SetConfig((phdlAmp_MPRFA_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_MPRFA */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phdlAmp_GetConfig(
                             void * pDataParams,
                             uint16_t wIdentifier,
                             uint16_t * pwValue
                             )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlAmp_GetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wIdentifier);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pwValue);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wIdentifier_log, &wIdentifier);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_AMP)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_AMP_AR75A250
    case PHDL_AMP_AR75A250_ID:
        status = phdlAmp_AR75A250_GetConfig((phdlAmp_AR75A250_DataParams_t *)pDataParams, wIdentifier, pwValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_AR75A250 */
#ifdef NXPBUILD__PHDL_AMP_BBA100
    case PHDL_AMP_BBA100_ID:
        status = phdlAmp_BBA100_GetConfig((phdlAmp_BBA100_DataParams_t *)pDataParams, wIdentifier, pwValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA100 */
#ifdef NXPBUILD__PHDL_AMP_BBA150
    case PHDL_AMP_BBA150_ID:
        status = phdlAmp_BBA150_GetConfig((phdlAmp_BBA150_DataParams_t *)pDataParams, wIdentifier, pwValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_BBA150 */
#ifdef NXPBUILD__PHDL_AMP_MPRFA
    case PHDL_AMP_MPRFA_ID:
        status = phdlAmp_MPRFA_GetConfig((phdlAmp_MPRFA_DataParams_t *)pDataParams, wIdentifier, pwValue);
        break;
#endif /* NXPBUILD__PHDL_AMP_MPRFA */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_AMP);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, pwValue_log, pwValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

#endif /* NXPBUILD__PHDL_AMP */
