/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Generic Amplifier Device Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLAMP_INT_H
#define PHDLAMP_INT_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phdlAmp_Int_Send(
                            phdlAmp_AR75A250_DataParams_t * pDataParams,
                            uint8_t * pTxBuffer,
                            uint16_t wTxLength
                            );

phStatus_t phdlAmp_Int_SendWait(
                                phdlAmp_AR75A250_DataParams_t * pDataParams,
                                uint8_t * pTxBuffer,
                                uint16_t wTxLength,
                                uint16_t wWaittime
                                );

#endif /* PHDLAMP_INT_H */
