/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO3 FDT Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_NxpBuild.h>

#ifdef NXPBUILD__PHDL_ISO3_FILTERCALIBRATION

#include <phdlISO3.h>


#include "phdlISO3_FilterCalibration.h"
#include "phdlISO3_FilterCalibration_Cmd.h"

#include <phdlOsci.h> /* for ISO3SoftScope COMP_ID */
#include <phhalHw.h>  /* for ISO3 HAL COMP_ID */
#include <phhalHw_ISO3_cmd.h>

phStatus_t phdlISO3_FilterCalibration_Init(
                        phdlISO3_FilterCalibration_DataParams_t * pDataParams,
                        uint16_t wSizeOfDataParams,
                        void * pHalDataParams,
                        void * pDlScopeDataParams
                        )
{
    if (sizeof(phdlISO3_FilterCalibration_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_ISO3);
    }

    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pHalDataParams);
    PH_ASSERT_NULL(pDlScopeDataParams);

    /* Check HAL data parameters */
    if (PH_GET_COMPCODE(pHalDataParams) != PH_COMP_HAL ||
        PH_GET_COMPID(pHalDataParams) != PHHAL_HW_ISO3_ID)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_ISO3);
    }

    /* Check DL Osci data parameters */
    if (PH_GET_COMPCODE(pDlScopeDataParams) != PH_COMP_DL_OSCI ||
        PH_GET_COMPID(pDlScopeDataParams) != PHDL_OSCI_ISO3SOFTSCOPE_ID)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_ISO3);
    }

    pDataParams->wId                    = PH_COMP_DL_ISO3 | PHDL_ISO3_FILTERCALIBRATION_ID;
    pDataParams->pHalDataParams         = pHalDataParams;
    pDataParams->pDlScopeDataParams     = pDlScopeDataParams;
    pDataParams->bUseRemoteBuffers      = (uint8_t) PH_OFF;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_ISO3);
}

phStatus_t phdlISO3_FilterCalibration_SetConfig(
                        phdlISO3_FilterCalibration_DataParams_t * pDataParams,
                        uint16_t wIdentifier,
                        uint16_t wValue)
{
    PH_ASSERT_NULL(pDataParams);

    switch (wIdentifier)
    {
    case PHDL_ISO3_FILTERCALIBRATION_CONFIG_USE_REMOTE_BUFFERS:
        if(wValue != PH_ON || wValue != PH_OFF)
        {
            PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_ISO3);
        }
        pDataParams->bUseRemoteBuffers = (uint8_t)wValue;
        break;
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_ISO3);
}

phStatus_t phdlISO3_FilterCalibration_GetConfig(
                        phdlISO3_FilterCalibration_DataParams_t * pDataParams,
                        uint16_t wIdentifier,
                        uint16_t* pwValue
                        )
{
    PH_ASSERT_NULL(pDataParams);

    *pwValue = 0;

    switch (wIdentifier)
    {
    case PHDL_ISO3_FILTERCALIBRATION_CONFIG_USE_REMOTE_BUFFERS:
        *pwValue = pDataParams->bUseRemoteBuffers;
        break;
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_ISO3);
}
#endif /* NXPBUILD__PHDL_ISO3_FILTERCALIBRATION */
