/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * AR75A250 Master Amplifier Oscilloscope Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLMSTAMPOSC_AR75A250_H
#define PHDLMSTAMPOSC_AR75A250_H

#include <ph_Status.h>


phStatus_t phdlMstAmpOsc_AR75A250_InitMstAmpOsc(
    phdlMstAmpOsc_AR75A250_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_AR75A250_SetConfig(
    phdlMstAmpOsc_AR75A250_DataParams_t * pDataParams,
    uint16_t wIdentifier,
    uint16_t wValue
    );

phStatus_t phdlMstAmpOsc_AR75A250_GetConfig(
    phdlMstAmpOsc_AR75A250_DataParams_t * pDataParams,
    uint16_t wIdentifier,
    uint16_t * pwValue
    );

phStatus_t phdlMstAmpOsc_AR75A250_Cal(
                                      phdlMstAmpOsc_AR75A250_DataParams_t * pDataParams
                                      );

phStatus_t phdlMstAmpOsc_AR75A250_SetFieldStrength(
    phdlMstAmpOsc_AR75A250_DataParams_t * pDataParams,
    uint16_t wFieldStrength
    );

#endif /* PHDLMSTAMPOSC_AR75A250_H */
