/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal AR75A250 Master Amplifier Oscilloscope Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phbalReg.h>
#include <phdlMstAmpOsc.h>
#include <ph_RefDefs.h>
#include <math.h>

#ifdef NXPBUILD__PHDL_MSTAMPOSC_AR75A250

#include "phdlMstAmpOsc_AR75A250.h"
#include "phdlMstAmpOsc_AR75A250_Int.h"

#include <phdlAmp.h>
#include <phdlOsci.h>

phStatus_t phdlMstAmpOsc_AR75A250_Int_CalcGainVal(
    phdlMstAmpOsc_AR75A250_DataParams_t * pDataParams,
    uint16_t wFieldStrength,
    uint16_t * pwGain
    )
{
    uint16_t wRange;
    uint16_t wLowerRange;
    uint16_t wUpperRange;
    uint16_t wLimit;
    uint16_t wGainLimit;
    int16_t wOffset;
    float32_t fK;
    float32_t fKLinearDec;

    /* calculate the whole range */
    wRange = (pDataParams->wMaxFieldStrengthAmp - pDataParams->wMinFieldStrengthAmp);

    /* calculate the lower Range */
    wLowerRange = (uint16_t) ( (float32_t) wRange * 22/100) ;

    /* calculate the upper range */
    wUpperRange = wRange - wLowerRange;

    /* calculate boarder for the LowerRange region */
    wLimit = pDataParams->wMinFieldStrengthAmp + (uint16_t) ( (float32_t) wRange * 22 /100 );

    /* calculate the corresponding gain limit (3000) */
    wGainLimit = (uint16_t) ((float32_t) (pDataParams->wMaxGainVal - pDataParams->wMinGainVal) * 3000 / 4095);

    /* factor for log Interpolation */
    fK = (float32_t) ((float32_t) (pDataParams->wMaxGainVal - pDataParams->wMinGainVal)  / log((float32_t)( (float32_t) pDataParams->wMaxFieldStrengthAmp/ (float32_t) pDataParams->wMinFieldStrengthAmp)));

    /* factor for linear substraction from log interpolation curve above 3000 */
    fKLinearDec = (float32_t) ( fK*log( (float32_t) pDataParams->wMaxFieldStrengthAmp/ (float32_t) wLimit)- (float32_t) (pDataParams->wMaxGainVal - wGainLimit))/ (float32_t) wUpperRange;

    /* calculation of offset */
    wOffset = (int16_t) (- (fK*log((float32_t)wLimit)) + (float32_t) wGainLimit);

    /* for values below 3000 the log interpolation is sufficient */
    if ( wFieldStrength <= wLimit)
    {
        *pwGain = (uint16_t)( (int16_t) (fK * log((float32_t)wFieldStrength)) + wOffset) ;
    }
    /* for values above 3000 a linear part is substracted from the log intpolation */
    else
    {
        *pwGain = (uint16_t)( (int16_t) (fK * log((float32_t)wFieldStrength)) + wOffset - (int16_t) (fKLinearDec * (float32_t) (wFieldStrength - wLimit)));
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_MSTAMPOSC);
}

#endif /* NXPBUILD__PHDL_MSTAMPOSC_AR75A250 */
