/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO3 Setup Software Master Amplifier Oscilloscope Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISO3

#include "phdlMstAmpOsc_ISO3.h"
#include "phdlMstAmpOsc_ISO3_Cmd.h"
#include "phdlMstAmpOsc_ISO3_Int.h"

#include <phhalHw_ISO3_Cmd.h>

phStatus_t phdlMstAmpOsc_ISO3_Cmd_SetFieldStrengthRatio(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams,
    uint32_t dwFieldStrengthRatio,
    uint8_t bAntennaType
    )
{
    phStatus_t statusTmp;
    phhalHw_ISO3_DataParams_t* pHalDataParams;
    uint32_t pTxBuffer[3];

    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pDataParams->pHalDataParams);

    pHalDataParams = (phhalHw_ISO3_DataParams_t*)pDataParams->pHalDataParams;

    if(bAntennaType == PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_1)
    {
        pDataParams->dwFieldStrengthRatioA1 = dwFieldStrengthRatio;

        pTxBuffer[0] = PHHAL_HW_ISO3_SERVER_CONF_FIELD_STRENGTH;
        pTxBuffer[1] = PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_1;
        pTxBuffer[2] = dwFieldStrengthRatio;
    }
    else if (bAntennaType == PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_2)
    {
        pDataParams->dwFieldStrengthRatioA2 = dwFieldStrengthRatio;

        pTxBuffer[0] = PHHAL_HW_ISO3_SERVER_CONF_FIELD_STRENGTH;
        pTxBuffer[1] = PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_2;
        pTxBuffer[2] = dwFieldStrengthRatio;
    }
    else if (bAntennaType == PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_3)
    {
        pDataParams->dwFieldStrengthRatioA3 = dwFieldStrengthRatio;

        pTxBuffer[0] = PHHAL_HW_ISO3_SERVER_CONF_FIELD_STRENGTH;
        pTxBuffer[1] = PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_3;
        pTxBuffer[2] = dwFieldStrengthRatio;
    }
    else
    {
        return PH_ADD_COMPCODE(PHDL_MSTAMPOSC_ERR_INVALID_ANTENNA_TYPE, PH_COMP_DL_MSTAMPOSC);
    }

    PH_CHECK_SUCCESS_FCT(statusTmp, phhalHw_ISO3_Cmd_SendServerCommand(
        pHalDataParams,
        PHHAL_HW_ISO3_SERVER_CMD_SET_CONFIG,
        (uint8_t*)&pTxBuffer,
        sizeof(pTxBuffer)));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_MSTAMPOSC);
}

phStatus_t phdlMstAmpOsc_ISO3_Cmd_GetFieldStrengthRatio(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams,
    uint32_t * pFieldStrengthRatio,
    uint8_t bAntennaType
    )
{
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL_PARAM(pFieldStrengthRatio, PH_COMP_DL_MSTAMPOSC);

    if(bAntennaType == PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_1)
    {
        *pFieldStrengthRatio = pDataParams->dwFieldStrengthRatioA1;
    }
    else if(bAntennaType == PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_2)
    {
        *pFieldStrengthRatio = pDataParams->dwFieldStrengthRatioA2;
    }
    else if(bAntennaType == PHDL_MSTAMPOSC_ISO3_ANTENNA_TYPE_3)
    {
        *pFieldStrengthRatio = pDataParams->dwFieldStrengthRatioA3;
    }
    else
    {
        return PH_ADD_COMPCODE(PHDL_MSTAMPOSC_ERR_INVALID_ANTENNA_TYPE, PH_COMP_DL_MSTAMPOSC);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_MSTAMPOSC);
}

#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISO3 */
