/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO3 Setup Software Master Amplifier Oscilloscope Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLMSTAMPOSC_ISO3_CMD_H
#define PHDLMSTAMPOSC_ISO3_CMD_H

#include <ph_Status.h>
#include <phdlMstAmpOsc.h>

phStatus_t phdlMstAmpOsc_ISO3_Cmd_SetFieldStrengthRatio(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams,
    uint32_t dwFieldStrengthRatio,
    uint8_t bAntennaType
    );

phStatus_t phdlMstAmpOsc_ISO3_Cmd_GetFieldStrengthRatio(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams,
    uint32_t * pFieldStrengthRatio,
    uint8_t bAntennaType
    );

#endif /* PHDLMSTAMPOSC_ISO3_H */
