/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO Setup Software Master Amplifier Oscilloscope Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLMSTAMPOSC_ISOSETUP_INT_H
#define PHDLMSTAMPOSC_ISOSETUP_INT_H

#include <ph_Status.h>

phStatus_t phdlMstAmpOsc_ISOSetup_Int_CheckFieldRange(
    phdlMstAmpOsc_ISOSetup_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_ISOSetup_Int_CalcPotiPos(
    phdlMstAmpOsc_ISOSetup_DataParams_t * pDataParams,
    uint16_t wFieldStrength,
    uint16_t * pwPotiPos
    );

phStatus_t phdlMstAmpOsc_ISOSetup_Int_CalcGainVal(
    phdlMstAmpOsc_ISOSetup_DataParams_t * pDataParams,
    uint16_t wFieldStrength,
    uint16_t * pwGain
    );

phStatus_t phdlMstAmpOsc_ISOSetup_Int_SetAmpGainRange(
    phdlMstAmpOsc_ISOSetup_DataParams_t * pDataParams,
    uint16_t wFieldStrength
    );

phStatus_t phdlMstAmpOsc_ISOSetup_Int_Cal(
    phdlMstAmpOsc_ISOSetup_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_ISO_Int_Setup_FindGainValues(
    phdlMstAmpOsc_ISOSetup_DataParams_t * pDataParams
    );

#endif /* PHDLMSTAMPOSC_ISOSETUP_INT_H */
