/*
 * Copyright 2017, 2020, 2022, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Oscilloscope Agilent DSO7052A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLOSCI_DSO7052A_INT_H
#define PHDLOSCI_DSO7052A_INT_H

#include <ph_Status.h>
#include <phdlOsci.h>

#define PHDLOSCI_DSO7052A_PREAMBLE_LENGTH 44
#define PHDLOSCI_DSO7052A_MAX_DATA_HEADER_LENGTH 10
#define PHDLOSCI_DSO7052A_MIN_DATA_HEADER_LENGTH 2
#define PHDLOSCI_DSO7052A_PREAMBLE_ITEM_COUNT 10

phStatus_t phdlOsci_DSO7052A_Int_ChkLastCmd(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_WaitExe(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_WaitArmed(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ClearArmed(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ChkCmd(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_GetAmpl(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bChannel,
    float32_t * pfAmplitude
    );

phStatus_t phdlOsci_DSO7052A_Int_GetPeakPeak(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bChannel,
    float64_t * pdfPkPk
    );

phStatus_t phdlOsci_DSO7052A_Int_SaveImage(
         phdlOsci_DSO7052A_DataParams_t * pDataParams,
         uint16_t wFilenameParameters
         );

phStatus_t phdlOsci_DSO7052A_Int_GetRMS(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bChannel,
    float32_t * pfRMS
    );

phStatus_t phdlOsci_DSO7052A_Int_IdentifyOscilloscope(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_SetChannelConfig(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t bChannel,
    uint8_t *pParam,
    uint8_t *pValue
    );

phStatus_t phdlOsci_DSO7052A_Int_GetChannelConfig(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t bChannel,
    uint8_t *pParam,
    uint8_t *pValue,
    uint16_t wValueSize
    );

phStatus_t phdlOsci_DSO7052A_Int_SetTriggerConfig(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t *pParam,
    uint8_t *pValue
    );

phStatus_t phdlOsci_DSO7052A_Int_GetTriggerConfig(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t *pParam,
    uint8_t *pValue,
    uint16_t wValueSize
    );

phStatus_t phdlOsci_DSO7052A_Int_SetTimebaseConfig(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t *pParam,
    uint8_t *pValue
    );

phStatus_t phdlOsci_DSO7052A_Int_GetTimebaseConfig(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t *pParam,
    uint8_t *pValue,
    uint16_t wValueSize
    );

phStatus_t phdlOsci_DSO7052A_Int_IsScopeRunning(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t *pIsRunning
    );

phStatus_t phdlOsci_DSO7052A_Int_ChannelOnOff(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t bActive,
    uint8_t bChannel
    );

phStatus_t phdlOsci_DSO7052A_Int_OverUndershoot(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bChannel,
    uint8_t * pBIsOverUnderShoot
    );

phStatus_t phdlOsci_DSO7052A_Int_CorrDiv(
    uint16_t wProbe,
    uint32_t  dwOldDiv,
    uint32_t * dwNewDiv
    );

phStatus_t phdlOsci_DSO7052A_Int_ConvertDivInCmd(
    uint32_t  dwDiv,
    uint8_t  bChannel,
    uint8_t * pCmdLength,
    uint8_t * pCmd
    );

phStatus_t phdlOsci_DSO7052A_Int_GetDiv(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bChannel,
    uint32_t * dwDiv
    );

phStatus_t phdlOsci_DSO7052A_Int_GetBestDiv(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint16_t wProbe,
    uint32_t dwOldDiv,
    float64_t dfPkPK,
    uint32_t * dwNewDiv
    );

phStatus_t phdlOsci_DSO7052A_Int_SetCorrRange(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bChannel
    );

phStatus_t phdlOsci_DSO7052A_Int_GetWaveForm(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bSource,
    uint32_t dwWaveFormBufferSize,
    uint32_t * pdwWaveFormLength,
    uint8_t * pWaveFormBuffer,
    uint8_t * pbHeaderOffset
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigFDT_PCD(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigFDT_PICC_106_L3(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigFDT_PICC_106_L4(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigFDT_PICC_212_L4(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigFDT_PICC_424_L4(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigFDT_PICC_848_L4(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigLive(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigGlobal(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigEmd(
    phdlOsci_DSO7052A_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_DSO7052A_Int_SetTriggerMode(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint16_t wTriggerMode
    );

phStatus_t phdlOsci_DSO7052A_Int_ConfigOsci(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t bConfig
    );

phStatus_t phdlOsci_DSO7052A_Int_ConvertStringToInt64(
    uint8_t *abBuffer,
    int64_t qwMultiplier,
    int64_t *pqwValue
    );

phStatus_t phdlOsci_DSO7052A_Int_Send(
	 phdlOsci_DSO7052A_DataParams_t * pDataParams,
	 uint8_t * pTxBuffer,
	 uint16_t wTxLength
	 );

phStatus_t phdlOsci_DSO7052A_Int_SendStringCheckStatus(
                             phdlOsci_DSO7052A_DataParams_t * pDataParams,
                             uint8_t * pTxBuffer
                             );

phStatus_t phdlOsci_DSO7052A_Int_SetCoupling(
     phdlOsci_DSO7052A_DataParams_t * pDataParams,
     uint8_t bChannel,
     uint8_t bACDC
    );

phStatus_t phdlOsci_DSO7052A_Int_GetAverage(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t  bChannel,
    float32_t * pfAverage
    );

phStatus_t phdlOsci_DSO7052A_Int_SendWait(
                                 phdlOsci_DSO7052A_DataParams_t * pDataParams,
                                 uint8_t * pTxBuffer,
                                 uint16_t wTxLength,
                                 uint16_t wWaittime
                                 );

phStatus_t phdlOsci_DSO7052A_Int_BalReg_VisaExchangeLarge(
    phdlOsci_DSO7052A_DataParams_t * pDataParams,
    uint8_t * pTxBuffer,   /**< [In] data to transmit */
    uint16_t wTxLength,    /**< [In] length of input data */
    uint32_t dwRxBufSize,   /**< [In] size of receive buffer */
    uint8_t * pRxBuffer,   /**< [Out] received data */
    uint32_t * pRxLength   /**< [Out] number of received data bytes */
    );

#endif /* PHDLOSCI_DSO7052A_INT_H */
