/*
 * Copyright 2017 - 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Oscilloscope Waverunner 64Xi Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phbalReg.h>
#include <ph_RefDefs.h>
#include <math.h>
#include <stdio.h>              /* PRQA S 5124 */

#ifdef NXPBUILD__PHDL_OSCI_LW64XI

/* for visa functionality displaced function exchange large */
#include "../../../phbalReg/src/Visa/external/visa.h"
#include "../../../phbalReg/src/Visa/phbalReg_Visa_Cmd.h"

#include "phdlOsci_LW64Xi.h"
#include "phdlOsci_LW64Xi_Int.h"
#include "../phdlOsci_Int.h"
#include <phdlOsci_LW64Xi_Cmd.h>

phStatus_t phdlOsci_LW64Xi_Cmd_SaveSetupSlotNumber(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t bSlotNumber
    )
{
    phStatus_t statusTmp;
    int32_t dwPrintLength = 0;
    uint8_t abCmd[15];

    /* check slot range */
    if(bSlotNumber < 1 || bSlotNumber > 6)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_OSCI);
    }

    /* build and send command */
    dwPrintLength = sprintf((char *)abCmd, "*SAV %d\n", bSlotNumber);
    PH_CHECK_SUCCESS_FCT(statusTmp, phhalReg_Visa_Cmd_Transmit(pDataParams->pBalRegDataParams, PH_EXCHANGE_DEFAULT, (uint8_t *)abCmd, (uint16_t)dwPrintLength));

    /* Wait for command and check execution status */
    PH_CHECK_SUCCESS_FCT(statusTmp,phdlOsci_LW64Xi_Int_ChkCmd(pDataParams));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_OSCI);
}

phStatus_t phdlOsci_LW64Xi_Cmd_RecallSetupSlotNumber(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t bSlotNumber
    )
{
    phStatus_t statusTmp;
    int32_t dwPrintLength = 0;
    uint8_t abCmd[15];

    /* check slot range */
    if(bSlotNumber < 1 || bSlotNumber > 6)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_OSCI);
    }

    /* build and send command */
    dwPrintLength = sprintf((char *)abCmd, "*RCL %d\n", bSlotNumber);
    PH_CHECK_SUCCESS_FCT(statusTmp, phhalReg_Visa_Cmd_Transmit(pDataParams->pBalRegDataParams, PH_EXCHANGE_DEFAULT, (uint8_t *)abCmd, (uint16_t)dwPrintLength));

    /* Wait for command and check execution status */
    PH_CHECK_SUCCESS_FCT(statusTmp,phdlOsci_LW64Xi_Int_ChkCmd(pDataParams));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_OSCI);
}

phStatus_t phdlOsci_LW64Xi_Cmd_SaveSetupFileName(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t *pFileName
    )
{
    phStatus_t statusTmp;
    int32_t dwPrintLength = 0;
    uint8_t abCmd[300];

    if(pFileName == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_OSCI);
    }

    /* check file name length and extension */
    dwPrintLength = (int32_t)strlen((char *)pFileName);
    if(dwPrintLength > 256 || dwPrintLength < 4 || !strncmp((char *)pFileName + dwPrintLength - 4, ".LSS", 4))
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_OSCI);
    }

    /* build and send command */
    dwPrintLength = sprintf((char *)abCmd, "STPN DISK, HDD, FILE, %s\n", pFileName);
    PH_CHECK_SUCCESS_FCT(statusTmp, phhalReg_Visa_Cmd_Transmit(pDataParams->pBalRegDataParams, PH_EXCHANGE_DEFAULT, (uint8_t *)abCmd, (uint16_t)dwPrintLength));

    /* Wait for command and check execution status */
    PH_CHECK_SUCCESS_FCT(statusTmp,phdlOsci_LW64Xi_Int_ChkCmd(pDataParams));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_OSCI);
}

phStatus_t phdlOsci_LW64Xi_Cmd_RecallSetupFileName(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t *pFileName
    )
{
    phStatus_t statusTmp;
    int32_t dwPrintLength = 0;
    uint8_t abCmd[300];

    if(pFileName == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_OSCI);
    }

    /* check file name length and extension */
    dwPrintLength = (int32_t)strlen((char *)pFileName);
    if(dwPrintLength > 256 || dwPrintLength < 4 || !strncmp((char *)pFileName + dwPrintLength - 4, ".LSS", 4))
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_OSCI);
    }

    /* build and send command */
    dwPrintLength = sprintf((char *)abCmd, "RCPN DISK, HDD, FILE, %s\n", pFileName);
    PH_CHECK_SUCCESS_FCT(statusTmp, phhalReg_Visa_Cmd_Transmit(pDataParams->pBalRegDataParams, PH_EXCHANGE_DEFAULT, (uint8_t *)abCmd, (uint16_t)dwPrintLength));

    /* Wait for command and check execution status */
    PH_CHECK_SUCCESS_FCT(statusTmp,phdlOsci_LW64Xi_Int_ChkCmd(pDataParams));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_OSCI);
}

#endif /* NXPBUILD__PHDL_OSCI_LW64Xi */
