/*
 * Copyright 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Oscilloscope PicoScope Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLOSCI_PICOSCOPE6000_H
#define PHDLOSCI_PICOSCOPE6000_H

#include <ph_Status.h>
#include <phdlOsci.h>


phStatus_t phdlOsci_PicoScope6000_SetConfig         (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     uint16_t wValue
                                                     );

phStatus_t phdlOsci_PicoScope6000_GetConfig         (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     uint16_t * pwValue
                                                     );

phStatus_t phdlOsci_PicoScope6000_SetConfig64       (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     int64_t qValue
                                                     );

phStatus_t phdlOsci_PicoScope6000_GetConfig64       (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     int64_t * pqValue
                                                     );

phStatus_t phdlOsci_PicoScope6000_GetFieldStrength  (
                                                    phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                    uint8_t bChannel,
                                                    uint16_t * pdwFieldStrength
                                                    );

phStatus_t phdlOsci_PicoScope6000_GetAmpl           (
                                                    phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                    uint8_t  bChannel,
                                                    uint16_t * pwAmplitude
                                                    );

phStatus_t phdlOsci_PicoScope6000_GetPeakPeak       (
                                                    phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                    uint8_t  bChannel,
                                                    float64_t * pdfPkPk
                                                    );

phStatus_t phdlOsci_PicoScope6000_GetRMS            (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint8_t  bChannel,
                                                     uint16_t * pwRMS
                                                     );

phStatus_t phdlOsci_PicoScope6000_GetRMSDouble       (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint8_t  bChannel,
                                                     float64_t * pdfRMS
                                                     );

phStatus_t phdlOsci_PicoScope6000_SetCorrRange      (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint8_t  bChannel
                                                     );

phStatus_t phdlOsci_PicoScope6000_InitOsci          (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams
                                                     );

phStatus_t phdlOsci_PicoScope6000_GetWaveForm       (
                                                     phdlOsci_PicoScope6000_DataParams_t * pDataParams,
                                                     uint8_t  bChannel,
                                                     uint32_t dwWaveFormBufferSize,
                                                     uint32_t * pdwWaveFormLength,
                                                     uint8_t * pbWaveFormBuffer,
                                                     uint8_t * pbHeaderOffset
                                                     );

#endif /* PHDLOSCI_PICOSCOPE6000_H */
