/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Generic Osciloscope Device Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLPOWERSUPPLY_INT_H
#define PHDLPOWERSUPPLY_INT_H

#include <ph_Status.h>
#include <phbalReg.h>
#include "phdlPowerSupply.h"

phStatus_t phdlPowerSupply_Int_Send(
                             phdlPowerSupply_E3631A_DataParams_t * pDataParams,
                             uint8_t * pTxBuffer,
                             uint16_t wTxLength
                             );

phStatus_t phdlPowerSupply_Int_SendWait(
                                 phdlPowerSupply_E3631A_DataParams_t * pDataParams,
                                 uint8_t * pTxBuffer,
                                 uint16_t wTxLength,
                                 uint16_t wWaittime
                                 );

phStatus_t phdlPowerSupply_Int_Atoui16(
                                int8_t * pAsci,
                                uint16_t * wURetVal
                                );

phStatus_t phdlPowerSupply_Int_Atoi16(
                               int8_t * pAsci,
                               int16_t * wIRetVal
                               );

phStatus_t phdlPowerSupply_Int_FindChar(
                                 int8_t * pAsci,
                                 int8_t bRef,
                                 uint8_t * bRetVal
                                 );

phStatus_t phdlPowerSupply_Int_FindStr(int8_t * pAsci,
                                int8_t * pRef,
                                uint8_t bRefSize,
                                uint8_t * pbStrFound
                                );

phStatus_t  phdlPowerSupply_Int_Atof(
                              int8_t * pAsci,
                              float32_t * fRetVal
                              );

#endif /* PHDLPOWERSUPPLY_INT_H */
