/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * FPGA Box V6 Device Layer Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLRDFPGA_V6_H
#define PHDLRDFPGA_V6_H

#include <ph_Status.h>
#include <phbalReg.h>
#include <phdlRdFpga.h>

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

#ifdef NXPBUILD__PHDL_RDFPGA_V6

    phStatus_t phdlRdFpga_V6_SetPotiPos(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wPos
        );

    phStatus_t phdlRdFpga_V6_SetDefaultPotiPos(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wPos
        );

    phStatus_t phdlRdFpga_V6_GetPotiPos(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t * pwPos
        );

    phStatus_t phdlRdFpga_V6_IncPotiPos(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_DecPotiPos(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_SetTimeOutVal(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwTimeOutVal
        );

    phStatus_t phdlRdFpga_V6_GetTimeOutVal(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t * pdwTimeOutVal
        );

    phStatus_t phdlRdFpga_V6_LoadJoinerIniFile(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pFilename
        );

    phStatus_t phdlRdFpga_V6_LoadPattern(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pFilename,
        uint8_t bId
        );

    phStatus_t phdlRdFpga_V6_PlayPattern(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t bId
        );

    phStatus_t phdlRdFpga_V6_PlaySeqA(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_PlaySeqB(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_PlaySinus(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_SelectTrigger(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t bTriggerSource
        );

    phStatus_t phdlRdFpga_V6_LabelReset(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wRisingEdgeCnt,
        uint32_t dwSinus,
        uint32_t dwHfPause
        );

    phStatus_t phdlRdFpga_V6_LabelResetCounterReset(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wRisingEdgeCnt,
        uint32_t dwSinus,
        uint32_t dwHfPause
        );

    phStatus_t phdlRdFpga_V6_LabelResetCounterResetSingleShot(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wRisingEdgeCnt,
        uint32_t dwSinus,
        uint32_t dwHfPause
        );

    phStatus_t phdlRdFpga_V6_LabelResetSingleShot(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wRisingEdgeCnt,
        uint32_t dwSinus,
        uint32_t dwHfPause
        );

    phStatus_t phdlRdFpga_V6_LabelResetWithCommand(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwSinus
        );

    phStatus_t phdlRdFpga_V6_ActivateFDTMeasurement(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_ActivateFastExchange(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_GetFDT(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t * pdwFdt
        );

    phStatus_t phdlRdFpga_V6_GetFDTFast(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t * pdwFdt
        );

    phStatus_t phdlRdFpga_V6_ActivateAntiTearingMode(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwSinus,
        uint32_t dwHfPause
        );

    phStatus_t phdlRdFpga_V6_ResFreqTest(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwHfPause,
        uint8_t bRepeatFreqId
        );

    phStatus_t phdlRdFpga_V6_ActivateFDTMeasurementPICCtoPCD(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwTime,
        uint8_t bCheckResp,
        uint16_t wRxByteCnt,
        uint8_t bRxBitCnt,
        uint8_t * pRxExpected
        );

    phStatus_t phdlRdFpga_V6_ActivateLMAMeasurement(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_ActivateSequencerMode(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_DeactivateModes(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_SetJoinerRxGain(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t bValue
        );

    phStatus_t phdlRdFpga_V6_GetJoinerRxGain(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pbValue
        );

    phStatus_t phdlRdFpga_V6_SetFDTPCDforActiveDS(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwValue
        );

    phStatus_t phdlRdFpga_V6_SetFDTPCDforDS(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwValue,
        uint8_t bId
        );

    phStatus_t phdlRdFpga_V6_GetConfig(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wIdentifier,
        uint16_t * pwValue
        );

    phStatus_t phdlRdFpga_V6_GetVersion(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pbValue
        );

    phStatus_t phdlRdFpga_V6_GetRevision(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pbValue
        );

    phStatus_t phdlRdFpga_V6_GetErrorCodes(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pbErrors,
        uint8_t bMaxErrorCnt,
        uint8_t * pbErrorCnt
        );

    phStatus_t phdlRdFpga_V6_SetClockSource(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint16_t wValue
        );

    phStatus_t phdlRdFpga_V6_GetFirstResponse(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pbRxBuffer,
        uint16_t wRxBufferSize,
        uint16_t * pwRxBytes,
        uint8_t * pbNumValidRxBits,
        int16_t * pwError
        );

    phStatus_t phdlRdFpga_V6_GetResponse(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pbRxBuffer,
        uint16_t wRxBufferSize,
        uint16_t * pwRxBytes,
        uint8_t * pbNumValidRxBits,
        int16_t * pwError
        );

    phStatus_t phdlRdFpga_V6_GetIQTimeoutValue(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t * pdwValue
        );

    phStatus_t phdlRdFpga_V6_SetIQTimeoutValue(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwValue
        );

    phStatus_t phdlRdFpga_V6_GetTerminalId(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint8_t * pbValue
        );

    phStatus_t phdlRdFpga_V6_ResetJoiner(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    phStatus_t phdlRdFpga_V6_SetConfig32(
                                phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwIdentifier,
        uint32_t dwValue,
        uint8_t bParamSetMode
                                );

    phStatus_t phdlRdFpga_V6_GetConfig32(
        phdlRdFpga_V6_DataParams_t * pDataParams,
        uint32_t dwIdentifier,
        uint32_t * dwValue
        );

    phStatus_t phdlRdFpga_V6_LoadFilterFile(
                                          phdlRdFpga_V6_DataParams_t * pDataParams,
                                          uint8_t * pFilename
                                          );

    phStatus_t phdlRdFpga_V6_ExchangeFPGACommand(
                                                phdlRdFpga_V6_DataParams_t * pDataParams,
                                                uint8_t * txData,
                                                uint32_t txLen,
                                                uint8_t * rxData,
                                                uint32_t maxRxLen,
                                                uint32_t * rxLen
                                                );

    phStatus_t phdlRdFpga_V6_ActivateTypeBMode(
        phdlRdFpga_V6_DataParams_t * pDataParams
        );

    /** @} */
#endif /* NXPBUILD__PHDL_RDFPGA_V6*/

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHDLRDFPGA_V6_H*/
