/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Spectrum Analyzer R&S FSV Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHDL_SPA_FSV

#include "phdlSPA_FSV.h"
#include "phdlSPA_FSV_Int.h"
#include "../phdlSPA_Int.h"

#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#include <stdio.h>              /* PRQA S 5124 */
#include <string.h>
#include <ctype.h>
#pragma warning(pop)            /* PRQA S 3116 */

phStatus_t phdlSPA_FSV_Int_Get_Max_Frequency(
                                              phdlSPA_FSV_DataParams_t * pDataParams,
                                              uint64_t * pqMaxFreq
                                             )
{
    double temp = pDataParams->bMaxFreq * 1e9;
    *pqMaxFreq = (uint64_t)temp;
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phdlSPA_FSV_Int_Set_Instrument_Parameter(
                                                    phdlSPA_FSV_DataParams_t * pDataParams,
                                                    int8_t * pbIdBuff,
                                                    uint8_t * bseperetorId
                                                   )
{
    phStatus_t statusTmp;
    uint8_t bI = 0, bRefCount = 0, iD = 0;
    uint8_t binstrumentStr [20];
    uint64_t maxVideoBandwidth = 0;
    uint16_t maxRfAttValue = 0;
    int64_t maxRefLevel = 0;

    for(bI = bseperetorId [0] + 1; bI < bseperetorId [1]; bI++)
    {
        binstrumentStr[bRefCount] = pbIdBuff[bI];
        pDataParams->bDevIdStr[bRefCount] = pbIdBuff[bI];
        bRefCount++;
    }

    binstrumentStr[bRefCount] = '\n';

    PH_CHECK_SUCCESS_FCT(statusTmp,  phdlSPA_Int_Send(pDataParams->pBalRegDataParams, (uint8_t *) "BANDwidth:VIDeo MAX", PH_ON));
    PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetUInt64WithoutRespLeng(pDataParams->pBalRegDataParams, (uint8_t *)"BANDwidth:VIDeo?", &maxVideoBandwidth));

    PH_CHECK_SUCCESS_FCT(statusTmp,  phdlSPA_Int_Send(pDataParams->pBalRegDataParams, (uint8_t *) "INPut:ATTenuation MAX", PH_ON));
    PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetUInt16WithoutRespLeng(pDataParams->pBalRegDataParams, (uint8_t *)"INPut:ATTenuation?", &maxRfAttValue));
    PH_CHECK_SUCCESS_FCT(statusTmp,  phdlSPA_Int_Send(pDataParams->pBalRegDataParams, (uint8_t *) "DISPlay:TRACe:Y:RLEVel MAX", PH_ON));
    PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetInt64WithoutRespLeng(pDataParams->pBalRegDataParams, (uint8_t *)"DISPlay:TRACe:Y:RLEVel?", PH_OFF, &maxRefLevel));

    if(strncmp((char *)PHDL_SPA_FSV_STR, (char *)binstrumentStr, strlen((char *)PHDL_SPA_FSV_STR)) == 0)
    {
        pDataParams->bMaxVideoBandwidth = maxVideoBandwidth;
        pDataParams->bMaxFreq = 4;
    }
    else if(strncmp((char *)PHDL_SPA_FSVR_STR, (char *)binstrumentStr, strlen((char *)PHDL_SPA_FSVR_STR)) == 0)
    {
        pDataParams->bMaxVideoBandwidth = maxVideoBandwidth;
        pDataParams->bMaxFreq = 7;
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
    }

    for(bI = bseperetorId[1] + 1; bI < bseperetorId[2]; bI++)
    {
        pDataParams->bDevId[iD] = pbIdBuff[bI];
        iD++;
    }

    pDataParams->bSwVersion[0] = pbIdBuff[bseperetorId[2] + 1];
    pDataParams->bSwVersion[1] = pbIdBuff[bseperetorId[2] + 2];
    pDataParams->bSwVersion[2] = pbIdBuff[bseperetorId[2] + 3];
    pDataParams->bSwVersion[3] = pbIdBuff[bseperetorId[2] + 4];
    pDataParams->bSwVersion[4] = pbIdBuff[bseperetorId[2] + 5];
    pDataParams->bSwVersion[5] = pbIdBuff[bseperetorId[2] + 6];
    pDataParams->bSwVersion[6] = pbIdBuff[bseperetorId[2] + 7];
    pDataParams->bSwVersion[7] = pbIdBuff[bseperetorId[2] + 8];

    pDataParams->wMaxRfAttValue = maxRfAttValue;
    pDataParams->qMaxRefLevel = maxRefLevel;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phdlSPA_FSV_Int_Set_Active_Probe(
                                            phdlSPA_FSV_DataParams_t * pDataParams,
                                            uint16_t wValue
                                           )
{
    phStatus_t statusTmp;

    PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_FSV_Int_Get_Active_Probe_Info(pDataParams));

    if(pDataParams->wActiveProbeState == PHDL_SPA_FSV_ACTIVE_PROBE_NOT_CONNECTED)
    {
        return PH_ADD_COMPCODE(PHDL_SPA_ERR_ACTIVE_PROBE_NOT_CONNECTED, PH_COMP_DL_SPA);
    }
    switch(wValue)
    {
    case PHDL_SPA_FSV_ACTIVE_PROBE_ACTIVATED:
        PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_Send(pDataParams->pBalRegDataParams, (uint8_t *) "PROBe:STATe ON", PH_ON));
        pDataParams->wActiveProbeState = PHDL_SPA_FSV_ACTIVE_PROBE_ACTIVATED;
        break;

    case PHDL_SPA_FSV_ACTIVE_PROBE_DEACTIVATED:
        PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_Send(pDataParams->pBalRegDataParams, (uint8_t *) "PROBe:STATe OFF", PH_ON));
        pDataParams->wActiveProbeState = PHDL_SPA_FSV_ACTIVE_PROBE_DEACTIVATED;
        break;

    default:
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_DL_SPA);
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_SPA);
}

phStatus_t phdlSPA_FSV_Int_Get_Active_Probe_Info(
                                                 phdlSPA_FSV_DataParams_t * pDataParams
                                                )
{
    phStatus_t statusTmp;
    uint8_t bI = 0;
    uint8_t bRespBuff[6] = {0};
    uint8_t bRespProbeName[10] = {0};
    uint8_t bRespProbeSerId[30] = {0};
    uint8_t bRespProbeParId[30] = {0};

    PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetResp(pDataParams->pBalRegDataParams, (uint8_t *)"PROBe:SETup:STATe?", bRespBuff, sizeof(bRespBuff)));

    if(strcmp((const char *)bRespBuff, "NDET") != true)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetResp(pDataParams->pBalRegDataParams, (uint8_t *) "PROBe:STATe?", bRespBuff, sizeof(bRespBuff)));
        if(strcmp((const char *)bRespBuff, "ON") == 0)
        {
            pDataParams->wActiveProbeState = PHDL_SPA_FSV_ACTIVE_PROBE_ACTIVATED;
        }
        else if(strcmp((const char *)bRespBuff, "OFF") == 0)
        {
            pDataParams->wActiveProbeState = PHDL_SPA_FSV_ACTIVE_PROBE_DEACTIVATED;
        }
        else
        {
            return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_DL_SPA);
        }

        PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetResp(pDataParams->pBalRegDataParams, (uint8_t *)"PROBe:SETup:NAME?", bRespProbeName, sizeof(bRespProbeName)));
        for(bI = 0; bI < sizeof(bRespProbeName); bI++)
        {
            pDataParams->bActiveProbeName[bI] = bRespProbeName[bI];
        }
        PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetResp(pDataParams->pBalRegDataParams, (uint8_t *)"PROBe:ID:SRNumber?", bRespProbeSerId, sizeof(bRespProbeSerId)));
        for(bI = 0; bI < sizeof(bRespProbeSerId); bI++)
        {
            pDataParams->bActiveProbeSerNum[bI] = bRespProbeSerId[bI];
        }
        PH_CHECK_SUCCESS_FCT(statusTmp, phdlSPA_Int_ExchangeGetResp(pDataParams->pBalRegDataParams, (uint8_t *)"PROBe:ID:PARTnumber?", bRespProbeParId, sizeof(bRespProbeParId)));
        for(bI = 0; bI < sizeof(bRespProbeParId); bI++)
        {
            pDataParams->bActiveProbePartId[bI] = bRespProbeParId[bI];
        }
    }
    else
    {
        pDataParams->wActiveProbeState = PHDL_SPA_FSV_ACTIVE_PROBE_NOT_CONNECTED;
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_SPA);
}
#endif /* NXPBUILD__PHDL_SPA_FSV */
