/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Stepper Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_DENSOVS60_INT_H
#define PHDLSTEPPER_DENSOVS60_INT_H

#include <ph_Status.h>
#include "phdlStepper_DensoVS60_External.h"

#ifdef __cplusplus
extern "C" {
#endif


/**
* \brief  ---
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_ConvertToStep(
                                                   phdlStepper_DensoVS60_DataParams_t * pDataParams,                                /**< [In] Pointer to this layer's parameter structure. */
                                                   int32_t dwDistance,                                                              /**< [In] Pointer to distance that should be traveled*/
                                                   int32_t * dwSteps                                                                /**< [In] Pointer to the number of steps */
                                                  );

/**
* \brief  ---
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_ConvertFromStep(
                                                     phdlStepper_DensoVS60_DataParams_t * pDataParams,                              /**< [In] Pointer to this layer's parameter structure. */
                                                     int32_t dwSteps,                                                               /**< [In] Pointer to the number of steps */
                                                     int32_t * dwDistance                                                           /**< [In] Pointer to distance that should be traveled*/
                                                    );

/**
* \brief  Default move command
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.nt.
*/
phStatus_t phdlStepper_DensoVS60_Int_GoToXYAxis(
                                          phdlStepper_DensoVS60_DataParams_t * pDataParams,                                         /**< [In] Pointer to this layer's parameter structure. */
                                          uint8_t bBlocking                                                                         /**< [In] blocking value of the robot */
                                         );

/**
* \brief  Default move command
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.nt.
*/
phStatus_t phdlStepper_DensoVS60_Int_GoToJointAxis(
                                          phdlStepper_DensoVS60_DataParams_t * pDataParams,                                         /**< [In] Pointer to this layer's parameter structure. */
                                          uint8_t bBlocking                                                                         /**< [In] blocking value of the robot */
                                         );

/**
* \brief  Move robot arm to the position given in X-Y cooridnates
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_GoToParameterXY(
                                                    phdlStepper_DensoVS60_DataParams_t * pDataParams,                               /**< [In] Pointer to this layer's parameter structure. */
                                                    uint8_t bBlocking                                                               /**< [In] blocking value of the robot */
                                                   );

/**
* \brief  Move robot arm to the position given in joint cooridnates
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_GoToParameterJoint(
                                                    phdlStepper_DensoVS60_DataParams_t * pDataParams,                               /**< [In] Pointer to this layer's parameter structure. */
                                                    uint8_t bBlocking                                                               /**< [In] blocking value of the robot */
                                                   );

/**
* \brief  Return current position as an array for X-Y cooridnates
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_GetPositionXY(
                                                   phdlStepper_DensoVS60_DataParams_t * pDataParams,                                /**< [In] Pointer to this layer's parameter structure. */
                                                   phdlStepper_DensoVS60_DataParams_XY_coord_t* currentCoordsXY                     /**< [In] Pointer to the XY cooridantes axis stucture */
                                                  );

/**
* \brief  Return current position as an array for joint cooridnates
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_GetPositionJoint(
                                                      phdlStepper_DensoVS60_DataParams_t * pDataParams,                             /**< [In] Pointer to this layer's parameter structure. */
                                                      phdlStepper_DensoVS60_DataParams_Joint_coord_t* currentCoordsJoint            /**< [In] Pointer to the Joint cooridantes axis stucture */
                                                     );

/**
* \brief  Set the current position as the zero point of the robot
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_SetAsZero(
                                               phdlStepper_DensoVS60_DataParams_t * pDataParams                                     /**< [In] Pointer to this layer's parameter structure. */
                                              );

/**
* \brief  ???
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_ManualMode(
                                                phdlStepper_DensoVS60_DataParams_t * pDataParams                                    /**< [In] Pointer to this layer's parameter structure. */
                                               );

/**
* \brief  Return current position as an array for joint cooridnates
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_Int_WaitMoveFinished (
                                                       phdlStepper_DensoVS60_DataParams_t * pDataParams                             /**< [In] Pointer to this layer's parameter structure. */
                                                      );

/* Commands for the DensoVS60 */
#define PHDL_STEPPER_DENSO_VS60_INT_SND_REQUEST_POSITION       (uint8_t *)"MRRP\r\n"
#define PHDL_STEPPER_DENSO_VS60_INT_SND_STATUS                 (uint8_t *)"MRST\r\n"
#define PHDL_STEPPER_DENSO_VS60_INT_SND_RESET_POSITION         (uint8_t *)"RSTH\r\n"
#define PHDL_STEPPER_DENSO_VS60_INT_SND_MANUAL_MODE            (uint8_t *)"MERD\r\n"
#define PHDL_STEPPER_DENSO_VS60_INT_SND_GOTO                   (uint8_t *)"MRGT %d %d %d %d %d %d %f\r\n"

/* postion counter value for limits for X-y axis */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_X				            580000      /* +/- 58 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_Y				            750000      /* +/- 50 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_Z				            700000      /* +/- 70 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_RX			            10000       /* +/- 10 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_RY			            10000       /* +/- 10 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_RZ			            10000       /* +/- 10 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_FIG			            10000       /* +/- 10 cm */
#define PHDL_STEPPER_DENSO_VS60_LIMIT_INNER_RADIUS              150000      /* +/- 15 cm */

#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_X	            1000         /* 100 cm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_Y		        1000         /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_Z		        4000         /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_RX		        5000         /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_RY   	        5000         /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_RZ		        5000         /* 0.5mm */

/* postion counter value for limits for joint axis
   TODO - check the correct values for limits */

#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J1				        300000   /* +/- 15 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J2				        300000   /* +/- 15 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J3			            300000   /* +/- 15 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J4			            300000   /* +/- 15 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J5			            300000   /* +/- 15 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J6			            300000   /* +/- 15 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J7			            300000   /* +/- 15 cm */
#define	PHDL_STEPPER_DENSO_VS60_LIMIT_J8			            300000   /* +/- 15 cm */

#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J1	            1000000  /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J2		        1000000  /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J3		        1000000  /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J4		        1000000  /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J5   	        1000000  /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J6		        1000000  /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J7		        1000000  /* 0.5mm */
#define	PHDL_STEPPER_DENSO_VS60_TOLERANCE_LIMIT_J8		        1000000  /* 0.5mm */

#ifdef __cplusplus
}
#endif

#endif /* PHDLSTEPPER_DENSOVS60_INT_H */
