/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Stepper Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_DENSOVS60_TOOLS_INT_H
#define PHDLSTEPPER_DENSOVS60_TOOLS_INT_H


#ifdef __cplusplus
#define EXTERNC extern "C"
#else
#define EXTERNC
#endif

#include <ph_Status.h>
#include <phdlStepper.h>
#include <WTypes.h>
#include "external\CAO.h"


// Function declaration

//Create workspace and start/stop functions
EXTERNC phStatus_t phdlStepper_DensoVS60_Int_Start_Motor();

EXTERNC phStatus_t phdlStepper_DensoVS60_Int_Create_Controller(phdlStepper_DensoVS60_DataParams_t * pDataParams);

EXTERNC phStatus_t phdlStepper_DensoVS60_Int_Stop_Motor();

//Move functions
EXTERNC phStatus_t phdlStepper_DensoVS60_Int_moveToCoord();

//Add Variables functions
phStatus_t phdlStepper_DensoVS60_Int_Attach_Default_IO_Variables();

phStatus_t phdlStepper_DensoVS60_Int_Attach_Optional_IO_Variables();

//Getter functions
ICaoController* phdlStepper_DensoVS60_Int_Get_Controller();

ICaoRobot* phdlStepper_DensoVS60_Int_Get_Robot();

ICaoEngine* phdlStepper_DensoVS60_Int_Get_Engine();

EXTERNC phStatus_t phdlStepper_DensoVS60_Int_Create_RobotArm();


//Check functions
HRESULT EndProc();


#undef EXTERNC


#endif /* PHDLSTEPPER_DENSOVS60_TOOLS_INT_H */
