/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Stepper Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_V1_INT_H
#define PHDLSTEPPER_V1_INT_H

#include <ph_Status.h>

phStatus_t phdlStepper_V1_Int_Initparam(
                                        phdlStepper_V1_DataParams_t * pDataParams
                                        );

phStatus_t  phdlStepper_V1_Int_GetLimits(
    phdlStepper_V1_DataParams_t * pDataParams
    );

phStatus_t phdlStepper_V1_Int_ReleaseFromLimit(
    phdlStepper_V1_DataParams_t * pDataParams
    );

phStatus_t phdlStepper_V1_Int_DataLength(
    uint8_t Identifier,
    uint16_t *pLength
    );

phStatus_t phdlStepper_V1_Int_GetFrame(
                                        uint8_t bCommand,
                                        uint32_t dwInput,
                                        uint8_t  * pFrame,
                                        uint16_t * wFrameLenth
                                        );

/* Commands for the stepper */
#define PHDL_STEPPER_V1_INT_SND_STATE					0x01U
#define PHDL_STEPPER_V1_INT_SND_RAMP_DELAY				0x02U
#define PHDL_STEPPER_V1_INT_SND_RAMP_ON_OFF				0x03U
#define PHDL_STEPPER_V1_INT_SND_DIRECTION				0x04U
#define PHDL_STEPPER_V1_INT_SND_START_SPEED				0x05U
#define PHDL_STEPPER_V1_INT_SND_MAX_SPEED				0x06U
#define PHDL_STEPPER_V1_INT_SND_STEPS					0x07U
#define PHDL_STEPPER_V1_INT_SND_STEPS_WAY_RATIO			0x08U
#define PHDL_STEPPER_V1_INT_SND_DISTANCE				0x09U
#define PHDL_STEPPER_V1_INT_SND_MAX_CURRENT				0x0AU
#define PHDL_STEPPER_V1_INT_SND_SBY_CURRENT				0x0BU
#define PHDL_STEPPER_V1_INT_SND_SBY_FLAG_CURRENT		0x0CU
#define PHDL_STEPPER_V1_INT_SND_POSITION_COUNTER		0x0DU
#define PHDL_STEPPER_V1_INT_SND_MAX_POSITION			0x0EU
#define PHDL_STEPPER_V1_INT_REQ_POSITION_COUNTER	    0x2BU

/* mode types for Drive Status */
#define PHDL_STEPPER_V1_INT_STATE_BEGIN_STATE_ENUM		0x0FU
#define PHDL_STEPPER_V1_INT_STATE_STDBY					0x10U
#define PHDL_STEPPER_V1_INT_STATE_DRIVE					0x11U
#define PHDL_STEPPER_V1_INT_STATE_DISTANCE_DRIVE		0x12U
#define PHDL_STEPPER_V1_INT_STATE_RELEASE_FROM_LIMIT	0x13U
#define PHDL_STEPPER_V1_INT_STATE_CONTINOUS_DRIVE		0x14U
#define PHDL_STEPPER_V1_INT_STATE_ENABLE_MANUAL_MODE	0x15U
#define PHDL_STEPPER_V1_INT_STATE_ERROR					0x16U
#define PHDL_STEPPER_V1_INT_STATE_END_STATE_ENUM		0x1fU

#endif /* PHDLSTEPPER_V1_INT_H */
