/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Steppper Wachler Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_WACHLER_H
#define PHDLSTEPPER_WACHLER_H

#include <ph_Status.h>
#include <phdlStepper.h>

phStatus_t  phdlStepper_Wachler_Initialize(
                                      phdlStepper_Wachler_DataParams_t * pDataParams
                                      );

phStatus_t phdlStepper_Wachler_MoveSteps(
                                    phdlStepper_Wachler_DataParams_t * pDataParams,
                                    uint16_t wSpeed,
                                    uint8_t bDirection,
                                    uint32_t dwSteps,
                                    uint8_t bBlocking
                                    );

phStatus_t phdlStepper_Wachler_MoveDistance(
                                       phdlStepper_Wachler_DataParams_t * pDataParams,
                                       uint16_t wSpeed,
                                       uint8_t bDirection,
                                       uint32_t dwDistance,
                                       uint8_t bBlocking
                                       );

phStatus_t phdlStepper_Wachler_GoToPosition(
                                       phdlStepper_Wachler_DataParams_t * pDataParams,
                                       uint16_t wSpeed,
                                       uint32_t dwPosition,
                                       uint8_t bBlocking
                                       );

phStatus_t phdlStepper_Wachler_SetConfig(
                                    phdlStepper_Wachler_DataParams_t * pDataParams,
                                    uint16_t wConfig,
                                    uint16_t wValue
                                    );

phStatus_t phdlStepper_Wachler_SetConfig32(
                                      phdlStepper_Wachler_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint32_t dwValue
                                      );

phStatus_t phdlStepper_Wachler_GetConfig(
                                    phdlStepper_Wachler_DataParams_t * pDataParams,
                                    uint16_t wConfig,
                                    uint16_t * pValue
                                    );

phStatus_t phdlStepper_Wachler_GetConfig32(
                                      phdlStepper_Wachler_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint32_t * pValue
                                      );

/* postion counter value for limits */
#define	PHDL_STEPPER_WACHLER_LIMIT_UPPER				0
#define	PHDL_STEPPER_WACHLER_LIMIT_LOWER				3768320  /* 23 cm 230*65536/4 */

/* maximum values for config */
#define PHDL_STEPPER_WACHLER_MAX_MAX_SPEED			0xFFFEU /* Not 0xFFFF so that that the Testbench does not fail */

#endif /* PHDLSTEPPER_WACHLER_H */
