/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Generic Thermostream Device Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLTHSTRM_INT_H
#define PHDLTHSTRM_INT_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phdlThstrm_Int_Send(
                               void * pBalRegDataParams,
                               uint8_t * pTxBuffer,
                               uint16_t wTxLength
                               );

phStatus_t phdlThstrm_Int_SendWait(
                                   void * pBalRegDataParams,
                                   uint8_t * pTxBuffer,
                                   uint16_t wTxLength,
                                   uint16_t wWaittime
                                   );

phStatus_t phdlThstrm_Int_Atoui16(
                                  int8_t * pAsci,
                                  uint16_t * wURetVal
                                  );

phStatus_t phdlThstrm_Int_Atoi32(
                               int8_t * pAsci,
                               int32_t * dwIRetVal
                               );

phStatus_t phdlThstrm_Int_MultTeni16(
                                 int8_t * pAsci,
                                 int16_t * wIRetVal
                                 );

#endif /* PHDLTHSTRM_INT_H */
