/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Dut Hal specific definition for Random Number commands.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7463 $
 * $Date: 2025-08-29 15:56:52 +0530 (Fri, 29 Aug 2025) $
 */


#include <ph_Status.h>

#ifdef NXPBUILD__PHHAL_HW_DUT_CMD_CRYPTORNG
#include <ph_RefDefs.h>
#include <phhalHw_DUT_Cmd.h>

#include "../phhalHw_DUT.h"

phStatus_t phhalHw_DUT_Cmd_CryptoRng_Init(phhalHw_DUT_DataParams_t * pDataParams)
{
    return PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CRYPTORNG_INIT,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        NULL,
        NULL);
}

phStatus_t phhalHw_DUT_Cmd_CryptoRng_DeInit(phhalHw_DUT_DataParams_t * pDataParams)
{
    return PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CRYPTORNG_DEINIT,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        NULL,
        NULL);
}

phStatus_t phhalHw_DUT_Cmd_CryptoRng_GetLastStatus(phhalHw_DUT_DataParams_t * pDataParams, uint16_t wStatusMsgLen, int8_t * pStatusMsg,
    int32_t * pStatusCode)
{
    phStatus_t wStatus = 0;
    uint8_t * pResponse = NULL;
    uint16_t wRspLen = 0;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CRYPTORNG_GET_STATUS,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pResponse,
        &wRspLen));

    /* Copy the status to response buffer. */
    (void) memcpy((uint8_t *) pStatusCode, pResponse, 4);

    /* Copy the status information if available. */
    if(wRspLen > 4)
    {
        wStatusMsgLen = (uint16_t) (pResponse[4] | (pResponse[5] << 8));
        (void) memcpy(pStatusMsg, &pResponse[6], 4);
    }

    return wStatus;
}

phStatus_t phhalHw_DUT_Cmd_CryptoRng_Seed(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pSeed, uint8_t bSeedLen)
{
    return PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CRYPTORNG_SEED,
        PH_EXCHANGE_DEFAULT,
        pSeed,
        bSeedLen,
        NULL,
        NULL);
}

phStatus_t phhalHw_DUT_Cmd_CryptoRng_Rnd(phhalHw_DUT_DataParams_t * pDataParams, uint16_t  wNoOfRndBytes, uint8_t * pRnd)
{
    phStatus_t wStatus = 0;
    uint8_t bCmdLen = 0;
    uint16_t wRspLen = 0;
    uint16_t wRndLen = 0;
    uint8_t bEndLoop = PH_OFF;

    uint8_t aCmd[2];
    uint8_t * pResponse = NULL;

    /* Prepare the command. */
    (void) memcpy(aCmd, (uint8_t *) &wNoOfRndBytes, 2);
    bCmdLen = 2;

    do
    {
        wStatus = PHHALHW_DUT_INT(
            pDataParams,
            PHHAL_HW_DUT_CMD_CRYPTORNG_RND,
            PH_EXCHANGE_DEFAULT,
            aCmd,
            bCmdLen,
            &pResponse,
            &wRspLen);

        /* Validate the Status */
        if(((wStatus & PH_ERR_MASK) == PH_ERR_SUCCESS) || ((wStatus & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING))
        {
            /* Copy the status to response buffer. */
            (void) memcpy(&pRnd[wRndLen], pResponse, wRspLen);
            wRndLen += wRspLen;

            /* Update loop flag in case of SUCCESS. */
            if((wStatus & PH_ERR_MASK) == PH_ERR_SUCCESS)
            {
                bEndLoop = PH_ON;
            }
        }
        else
        {
            bEndLoop = PH_ON;
        }

        /* Reset Command Length. */
        bCmdLen = 0;

    } while(bEndLoop != PH_ON);

    return wStatus;
}

#endif /* NXPBUILD__PHHAL_HW_DUT_CMD_CRYPTORNG */
