/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hal DUT specific definition I2C Peripheral commands.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7463 $
 * $Date: 2025-08-29 15:56:52 +0530 (Fri, 29 Aug 2025) $
 *
 * History:
 *   Created On 12 October, 2022
 *
 */

#include <ph_Status.h>

#ifdef NXPBUILD__PHHAL_HW_DUT_CMD_I2C
#include <ph_RefDefs.h>
#include <phhalHw_DUT_Cmd.h>

#include "../phhalHw_DUT.h"

phStatus_t phhalHw_DUT_Cmd_I2C_Exchange(phhalHw_DUT_DataParams_t * pDataParams, uint16_t wOption, uint16_t wSlaveAddr, uint8_t * pTxBuff,
    uint16_t wTxLen, uint16_t wBytesToRead, uint8_t ** ppRxBuff, uint16_t * pRxLen)
{
    /* TODO: Requires Implementation */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(wSlaveAddr);
    PH_UNUSED_VARIABLE(pTxBuff);
    PH_UNUSED_VARIABLE(wTxLen);
    PH_UNUSED_VARIABLE(wBytesToRead);
    PH_UNUSED_VARIABLE(ppRxBuff);
    PH_UNUSED_VARIABLE(pRxLen);

    /* TODO: User PHHALHW_DUT_INT_I2C Interface call. */

    return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_HAL);
}

phStatus_t phhalHw_DUT_Cmd_I2C_Transmit(phhalHw_DUT_DataParams_t * pDataParams, uint16_t wOption, uint16_t wSlaveAddr, uint8_t * pTxBuff,
    uint16_t wTxLen)
{
    /* TODO: Requires Implementation */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(wSlaveAddr);
    PH_UNUSED_VARIABLE(pTxBuff);
    PH_UNUSED_VARIABLE(wTxLen);

    /* TODO: User PHHALHW_DUT_INT_I2C Interface call. */

    return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_HAL);
}

phStatus_t phhalHw_DUT_Cmd_I2C_Receive(phhalHw_DUT_DataParams_t * pDataParams, uint16_t wOption, uint16_t wSlaveAddr, uint16_t wBytesToRead,
    uint8_t ** ppRxBuff, uint16_t * pRxLen)
{
    /* TODO: Requires Implementation */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(wSlaveAddr);
    PH_UNUSED_VARIABLE(wBytesToRead);
    PH_UNUSED_VARIABLE(ppRxBuff);
    PH_UNUSED_VARIABLE(pRxLen);

    /* TODO: User PHHALHW_DUT_INT_I2C Interface call. */

    return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_HAL);
}

phStatus_t phhalHw_DUT_Cmd_I2C_Start(phhalHw_DUT_DataParams_t * pDataParams)
{
    /* TODO: Requires Implementation */
    PH_UNUSED_VARIABLE(pDataParams);

    /* TODO: User PHHALHW_DUT_INT Interface call. */

    return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_HAL);
}

phStatus_t phhalHw_DUT_Cmd_I2C_Stop(phhalHw_DUT_DataParams_t * pDataParams)
{
    /* TODO: Requires Implementation */
    PH_UNUSED_VARIABLE(pDataParams);

    /* TODO: User PHHALHW_DUT_INT Interface call. */

    return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_HAL);
}

phStatus_t phhalHw_DUT_Cmd_I2C_RepeatedStart(phhalHw_DUT_DataParams_t * pDataParams)
{
    /* TODO: Requires Implementation */
    PH_UNUSED_VARIABLE(pDataParams);

    /* TODO: User PHHALHW_DUT_INT Interface call. */

    return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_HAL);
}

#endif /* NXPBUILD__PHHAL_HW_DUT_CMD_I2C */
