/*
 * Copyright 2018, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * DUT specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7463 $
 * $Date: 2025-08-29 15:56:52 +0530 (Fri, 29 Aug 2025) $
 *
 * History:
 *      Created On February 14, 2018
 *
 */

#ifndef PHHALHW_DUT_H
#define PHHALHW_DUT_H

#include <ph_Status.h>

#include <phhalHw.h>
#include <phhalHw_DUT_Cmd.h>

#define PHHAL_HW_DUT_FRAME_HEADER_LEN                       6U  /**< Length of a command header. */
#define PHHAL_HW_DUT_FRAME_CMD_POS                          0U  /**< Position of the command code (ushort). */
#define PHHAL_HW_DUT_FRAME_STATUS_POS                       2U  /**< Position of the status (ushort). */
#define PHHAL_HW_DUT_FRAME_LEN_POS                          4U  /**< Position of the length (ushort). */
#define PHHAL_HW_DUT_FRAME_PAYLOAD_POS                      6U  /**< Position of the payload. */





/* Reader Operation Commands ----------------------------------------------------------------------------------------------------------- */
#define phhalHw_DUT_ReadRegister                            phhalHw_DUT_Cmd_RdOps_Read_Register
#define phhalHw_DUT_WriteRegister                           phhalHw_DUT_Cmd_RdOps_Write_Register
#define phhalHw_DUT_FieldOn                                 phhalHw_DUT_Cmd_RdOps_FieldOn
#define phhalHw_DUT_FieldOff                                phhalHw_DUT_Cmd_RdOps_FieldOff
#define phhalHw_DUT_FieldReset                              phhalHw_DUT_Cmd_RdOps_FieldReset





/* HAL Operation Commands -------------------------------------------------------------------------------------------------------------- */
#define phhalHw_DUT_Exchange                                phhalHw_DUT_Cmd_HAL_Exchange
#define phhalHw_DUT_SetConfig                               phhalHw_DUT_Cmd_HAL_SetConfig
#define phhalHw_DUT_GetConfig                               phhalHw_DUT_Cmd_HAL_GetConfig
#define phhalHw_DUT_ApplyProtocolSettings                   phhalHw_DUT_Cmd_HAL_ApplyProtocolSettings
#define phhalHw_DUT_Wait                                    phhalHw_DUT_Cmd_HAL_Wait
#define phhalHw_DUT_MfcAuthenticate                         phhalHw_DUT_Cmd_HAL_MfcAuthenticate
#define phhalHw_DUT_Command                                 phhalHw_DUT_Cmd_HAL_Execute
#define phhalHw_DUT_MfcAuthenticateKeyNo                    phhalHw_DUT_Cmd_HAL_MfcAuthenticateKeyNo
#define phhalHw_DUT_Transmit                                phhalHw_DUT_Cmd_HAL_Transmit
#define phhalHw_DUT_Recieve                                 phhalHw_DUT_Cmd_HAL_Recieve
#define phhalHw_DUT_I18000p3m3Inventory                     phhalHw_DUT_Cmd_HAL_I18000p3m3Inventory
#define phhalHw_DUT_I18000p3m3ResumeInventory               phhalHw_DUT_Cmd_HAL_I18000p3m3ResumeInventory




#define PHHALHW_DUT_INT(DataParams, Cmd, Option, TxBuff, TxLen, RxBuff, RxLen)  \
    phhalHw_DUT_Int(DataParams, Cmd, 0, Option, TxBuff, TxLen, 0, RxBuff, RxLen)

#define PHHALHW_DUT_INT_I2C(DataParams, Cmd, SlaveAddr, Option, TxBuff, TxLen, BytesToRead, RxBuff, RxLen)  \
    phhalHw_DUT_Int(DataParams, Cmd, SlaveAddr, Option, TxBuff, TxLen, BytesToRead, RxBuff, RxLen)

phStatus_t phhalHw_DUT_Int(phhalHw_DUT_DataParams_t * pDataParams, uint16_t wCmd, uint16_t wSlaveAddr, uint16_t wOption, uint8_t * pTxBuff,
    uint16_t wTxLen, uint16_t wBytesToRead, uint8_t ** ppRxBuff, uint16_t * pRxLen);

phStatus_t phhalHw_DUT_SetMinFDT(phhalHw_DUT_DataParams_t * pDataParams, uint16_t wValue);

#endif /* PHHALHW_DUT_H */
