/*
 * Copyright 2015 - 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PCSC generic HAL interface.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_PCSC_H
#define PHHALHW_PCSC_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHHAL_HW_PCSC
#include <phhalHw.h>

#define PHHAL_HW_SET_PARITY             0x0CU
#define PHHAL_HW_SET_TXCRC              0x01U
#define PHHAL_HW_SET_RXCRC              0x02U

/**
* \brief PCSC implementation of Exchange.
*
* \sa phhalHw_Exchange
*/
phStatus_t phhalHw_Pcsc_Exchange(
    phhalHw_Pcsc_DataParams_t * pDataParams,          /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wOption,                                 /**< [In] Option parameter. */
    uint8_t * pTxBuffer,                              /**< [In] Data to transmit. */
    uint16_t wTxLength,                               /**< [In] Number of bytes to transmit. */
    uint8_t ** ppRxBuffer,                            /**< [Out] Pointer to received data. */
    uint16_t * pRxLength                              /**< [Out] Number of received data bytes. */
    );

/**
* \brief Pcsc implementation of SetConfig.
*
* \sa phhalHw_SetConfig
*/
phStatus_t phhalHw_Pcsc_SetConfig(
    phhalHw_Pcsc_DataParams_t * pDataParams,          /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wConfig,                                 /**< [In] Configuration Identifier. */
    uint16_t wValue                                   /**< [In] Configuration Value. */
    );

/**
* \brief Pcsc implementation of GetConfig.
*
* \sa phhalHw_GetConfig
*/
phStatus_t phhalHw_Pcsc_GetConfig(
    phhalHw_Pcsc_DataParams_t * pDataParams,          /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wConfig,                                 /**< [In] Configuration Identifier. */
    uint16_t * pValue                                 /**< [Out] Configuration Value. */
    );

/**
* \brief Pcsc implementation of MfcAuthenticateKeyNo.
*
* \sa phhalHw_MfcAuthenticateKeyNo
*/
phStatus_t phhalHw_Pcsc_MfcAuthenticateKeyNo(
    phhalHw_Pcsc_DataParams_t * pDataParams,          /**< [In] Pointer to this layer's parameter structure. */
    uint8_t bBlockNo,                                 /**< [In] Block-Number on card to authenticate to. */
    uint8_t bKeyType,                                 /**< [In] Either #PHHAL_HW_MFC_KEYA or #PHHAL_HW_MFC_KEYB. */
    uint16_t wKeyNo,                                  /**< [In] Key number to be used in authentication. */
    uint16_t wKeyVersion,                             /**< [In] Key version to be used in authentication. */
    uint8_t * pUid                                    /**< [In] Serial number of current cascade level; uint8_t[4]. */
    );

/**
* \brief Pcsc implementation of MfcAuthenticate.
*
* \sa phhalHw_MfcAuthenticate
*/
phStatus_t phhalHw_Pcsc_MfcAuthenticate(
    phhalHw_Pcsc_DataParams_t * pDataParams,          /**< [In] Pointer to this layer's parameter structure. */
    uint8_t bBlockNo,                                 /**< [In] Block number. */
    uint8_t bKeyType,                                 /**< [In] Key type to be used KEY_A or KEY_B. */
    uint8_t * pKey,                                   /**< [In] Key to be used for authentication. */
    uint8_t * pUid                                    /**< [In] UID of the tag to be authenticated. */
    );

/**
* \brief Pcsc implementation of ApplyProtocolSettings.
*
* \sa phhalHw_ApplyProtocolSettings
*/
phStatus_t phhalHw_Pcsc_ApplyProtocolSettings(
    phhalHw_Pcsc_DataParams_t * pDataParams,          /**< [In] Pointer to this layer's parameter structure. */
    uint8_t bCardType                                 /**< [In] Type of card for which the HAL should be configured for. */
    );

/**
* \brief Pcsc implementation of FieldOn.
*
* \sa phhalHw_FieldOn
*/
phStatus_t phhalHw_Pcsc_FieldOn(
    phhalHw_Pcsc_DataParams_t * pDataParams           /**< [In] Pointer to this layer's parameter structure. */
    );

/**
* \brief Pcsc implementation of FieldOff.
*
* \sa phhalHw_FieldOff
*/
phStatus_t phhalHw_Pcsc_FieldOff(
    phhalHw_Pcsc_DataParams_t * pDataParams           /**< [In] Pointer to this layer's parameter structure. */
    );

/**
* \brief Pcsc implementation of FieldReset.
*
* \sa phhalHw_FieldReset
*/
phStatus_t phhalHw_Pcsc_FieldReset(
    phhalHw_Pcsc_DataParams_t * pDataParams           /**< [In] Pointer to this layer's parameter structure. */
    );

/**
* \brief Pcsc implementation of Wait.
*
* \sa phhalHw_Wait
*/
phStatus_t phhalHw_Pcsc_Wait(
    phhalHw_Pcsc_DataParams_t * pDataParams,          /**< [In] Pointer to this layer's parameter structure. */
    uint8_t bUnit,                                    /**< [In] Unit of given timeout value (either #PHHAL_HW_TIME_MICROSECONDS or #PHHAL_HW_TIME_MILLISECONDS). */
    uint16_t wTimeout                                 /**< [In] Timeout value. */
    );

#endif /* NXPBUILD__PHHAL_HW_PCSC */
#endif  /* PHHALHW_PCSC_H */
