/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Rc632 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RC632_H
#define PHHALHW_RC632_H

#include <ph_Status.h>
#include <phhalHw.h>
#include "phhalHw_Rc632_Reg.h"

phStatus_t phhalHw_Rc632_Exchange(
								  phhalHw_Rc632_DataParams_t * pDataParams,
								  uint16_t wOption,
								  uint8_t * pTxBuffer,
								  uint16_t wTxLength,
								  uint8_t ** ppRxBuffer,
								  uint16_t * pRxLength
								  );

phStatus_t phhalHw_Rc632_WriteRegister(
									   phhalHw_Rc632_DataParams_t * pDataParams,
									   uint8_t bAddress,
									   uint8_t bValue
									   );

phStatus_t phhalHw_Rc632_ReadRegister(
									  phhalHw_Rc632_DataParams_t * pDataParams,
									  uint8_t bAddress,
									  uint8_t * pValue
									  );


phStatus_t phhalHw_Rc632_ApplyProtocolSettings(
	phhalHw_Rc632_DataParams_t * pDataParams,
	uint8_t bCardType
	);

phStatus_t phhalHw_Rc632_MfcAuthenticateKeyNo(
	phhalHw_Rc632_DataParams_t * pDataParams,
	uint8_t bBlockNo,
	uint8_t bKeyType,
	uint16_t wKeyNo,
	uint16_t wKeyVersion,
	uint8_t * pUid
	);

phStatus_t phhalHw_Rc632_MfcAuthenticate(
	phhalHw_Rc632_DataParams_t * pDataParams,
	uint8_t bBlockNo,
	uint8_t bKeyType,
	uint8_t * pKey,
	uint8_t * pUid
	);

phStatus_t phhalHw_Rc632_SetConfig(
								   phhalHw_Rc632_DataParams_t * pDataParams,
								   uint16_t wConfig,
								   uint16_t wValue
								   );

phStatus_t phhalHw_Rc632_GetConfig(
								   phhalHw_Rc632_DataParams_t * pDataParams,
								   uint16_t wConfig,
								   uint16_t * pValue
								   );

phStatus_t phhalHw_Rc632_FieldOn(phhalHw_Rc632_DataParams_t * pDataParams);

phStatus_t phhalHw_Rc632_FieldOff(phhalHw_Rc632_DataParams_t * pDataParams);

phStatus_t phhalHw_Rc632_FieldReset(phhalHw_Rc632_DataParams_t * pDataParams);

phStatus_t phhalHw_Rc632_Wait(
							  phhalHw_Rc632_DataParams_t * pDataParams,
							  uint8_t bUnit,
							  uint32_t wTimeout
							  );

phStatus_t phhalHw_Rc632_SetMinFDT(
                                    phhalHw_Rc632_DataParams_t * pDataParams,
                                    uint16_t wValue
                                    );
#endif /* PHHALHW_RC632_H */
