/*
 * Copyright 2013 - 2019, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic HAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phhalHw.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_RC663
#include "Rc663/phhalHw_Rc663.h"
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
#include "Rc523/phhalHw_Rc523.h"
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
#include "Rd70x/phhalHw_Rd70x.h"
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RC632
#include "Rc632/phhalHw_Rc632.h"
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_RD710
#include "Rd710/phhalHw_Rd710.h"
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
#include "Mp300/phhalHw_Mp300.h"
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
#include "ISO3/phhalHw_ISO3.h"
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
#include "Callback/phhalHw_Callback.h"
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAM
#include "Sam/phhalHw_Sam.h"
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#include "SamAV2/phhalHw_SamAV2.h"
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
#include "SamAV3/phhalHw_SamAV3.h"
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
#include "RdCardSim/phhalHw_RdCardSim.h"
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_PCSC
#include "Pcsc/phhalHw_Pcsc.h"
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
#include "MfcCrypto/phhalHw_MfcCrypto.h"
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
#include "RdFpgaV6/phhalHw_RdFpgaV6.h"
#endif /* NXPBUILD__PHHAL_HW_RDFPGAV6 */

#ifdef NXPBUILD__PHHAL_HW_LICENSEEWRAPPER
#include "LicenseeWrapper/phhalHw_LicenseeWrapper.h"
#endif /* NXPBUILD__PHHAL_HW_LICENSEEWRAPPER */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
#include "ProxiLAB/phhalHw_ProxiLAB.h"
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
#include "DUT/phhalHw_DUT.h"
#endif /* NXPBUILD__PHHAL_HW_DUT */

#ifdef NXPBUILD__PHHAL_HW

phStatus_t phhalHw_Exchange(void * pDataParams, uint16_t wOption, uint8_t * pTxBuffer, uint16_t wTxLength, uint8_t ** ppRxBuffer,
    uint16_t * pRxLength)
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_Exchange");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wOption_log, &wOption);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pTxBuffer_log, pTxBuffer, wTxLength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    if(wTxLength) PH_ASSERT_NULL(pTxBuffer);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);
        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_Exchange((phhalHw_Rc663_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_Exchange((phhalHw_Rc523_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_Exchange((phhalHw_Rd70x_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_Exchange((phhalHw_Rd710_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_Exchange((phhalHw_Mp300_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_Exchange((phhalHw_ISO3_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_Exchange((phhalHw_Callback_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_Exchange((phhalHw_SamAV2_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_Exchange((phhalHw_SamAV3_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_Exchange((phhalHw_Sam_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_Exchange((phhalHw_RdCardSim_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_Exchange((phhalHw_MfcCrypto_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_Exchange((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_Exchange((phhalHw_Rc632_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_Exchange((phhalHw_ProxiLAB_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_LICENSEEWRAPPER
        case PHHAL_HW_LICENSEEWRAPPER_ID:
            status = phhalHw_LicenseeWrapper_Exchange((phhalHw_LicenseeWrapper_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_LICENSEEWRAPPER */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_Exchange((phhalHw_Pcsc_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_Exchange((phhalHw_DUT_DataParams_t *) pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */
        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if((((status & PH_ERR_MASK) == PH_ERR_SUCCESS) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_INCOMPLETE_BYTE)) &&
        !(wOption & PH_EXCHANGE_BUFFERED_BIT) &&
        (ppRxBuffer != NULL))
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *pRxLength);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_WriteRegister(void * pDataParams, uint8_t bAddress, uint8_t bValue)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_WriteRegister");

    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bAddress);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bAddress_log, &bAddress);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bValue_log, &bValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_WriteRegister((phhalHw_Rc663_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_WriteRegister((phhalHw_Rc523_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_WriteRegister((phhalHw_Rd70x_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_WriteRegister((phhalHw_Rd710_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_WriteRegister((phhalHw_Mp300_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_WriteRegister((phhalHw_ISO3_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_WriteRegister((phhalHw_Callback_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_WriteRegister((phhalHw_SamAV2_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_WriteRegister((phhalHw_SamAV3_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_WriteRegister((phhalHw_Sam_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_WriteRegister((phhalHw_RdCardSim_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_WriteRegister((phhalHw_MfcCrypto_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_WriteRegister((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_WriteRegister((phhalHw_Rc632_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_WriteRegister((phhalHw_ProxiLAB_DataParams_t *) pDataParams, bAddress, bValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */
        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_ReadRegister(void * pDataParams, uint8_t bAddress, uint8_t * pValue)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_ReadRegister");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bAddress);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bAddress_log, &bAddress);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pValue);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_ReadRegister((phhalHw_Rc663_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_ReadRegister((phhalHw_Rc523_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_ReadRegister((phhalHw_Rd70x_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_ReadRegister((phhalHw_Rd710_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_ReadRegister((phhalHw_Mp300_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_ReadRegister((phhalHw_ISO3_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_ReadRegister((phhalHw_Callback_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_ReadRegister((phhalHw_SamAV2_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_ReadRegister((phhalHw_SamAV3_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_ReadRegister((phhalHw_Sam_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_ReadRegister((phhalHw_RdCardSim_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_ReadRegister((phhalHw_MfcCrypto_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_ReadRegister((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_ReadRegister((phhalHw_Rc632_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_ReadRegister((phhalHw_ProxiLAB_DataParams_t *) pDataParams, bAddress, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */
        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, pValue_log, pValue);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_ExecuteCmd(void * pDataParams, uint8_t bCmd, uint16_t wOption, uint8_t bIrq0WaitFor, uint8_t bIrq1WaitFor,
    uint8_t * pTxBuffer, uint16_t wTxLength, uint16_t wRxBufferSize, uint8_t * pRxBuffer, uint16_t * pRxLength)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_ExecuteCmd");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCmd);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bIrq0WaitFor);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bIrq1WaitFor);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wTxLength);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wRxBufferSize);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pRxLength);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCmd_log, &bCmd);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wOption_log, &wOption);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bIrq0WaitFor_log, &bIrq0WaitFor);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bIrq1WaitFor_log, &bIrq1WaitFor);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pTxBuffer_log, pTxBuffer, wTxLength);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wTxLength_log, &wTxLength);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wRxBufferSize_log, &wRxBufferSize);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_ExecuteCmd((phhalHw_Rc663_DataParams_t *) pDataParams, bCmd, wOption, bIrq0WaitFor,
                bIrq1WaitFor, pTxBuffer, wTxLength, wRxBufferSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, pRxLength_log, pRxLength);
    if(*pRxLength > 0)
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pRxBuffer_log, pRxBuffer, *pRxLength);
    }
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_ApplyProtocolSettings(void * pDataParams, uint8_t bCardType)
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_ApplyProtocolSettings");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCardType);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCardType_log, &bCardType);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_ApplyProtocolSettings((phhalHw_Rc663_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_ApplyProtocolSettings((phhalHw_DUT_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_ApplyProtocolSettings((phhalHw_Rc523_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_ApplyProtocolSettings((phhalHw_Rd70x_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_ApplyProtocolSettings((phhalHw_Rd710_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_ApplyProtocolSettings((phhalHw_Mp300_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_ApplyProtocolSettings((phhalHw_ISO3_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_ApplyProtocolSettings((phhalHw_Callback_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_ApplyProtocolSettings((phhalHw_SamAV2_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_ApplyProtocolSettings((phhalHw_SamAV3_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_ApplyProtocolSettings((phhalHw_Sam_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_ApplyProtocolSettings((phhalHw_RdCardSim_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_ApplyProtocolSettings((phhalHw_MfcCrypto_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_ApplyProtocolSettings((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, bCardType);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_ApplyProtocolSettings((phhalHw_Rc632_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_ApplyProtocolSettings((phhalHw_Pcsc_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_LICENSEEWRAPPER
        case PHHAL_HW_LICENSEEWRAPPER_ID:
            status = phhalHw_LicenseeWrapper_ApplyProtocolSettings((phhalHw_LicenseeWrapper_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_LICENSEEWRAPPER */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_ApplyProtocolSettings((phhalHw_ProxiLAB_DataParams_t *) pDataParams, bCardType);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue)
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_SetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wConfig_log, &wConfig);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wValue_log, &wValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_SetConfig((phhalHw_Rc663_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_SetConfig((phhalHw_Rc523_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_SetConfig((phhalHw_Rd70x_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_SetConfig((phhalHw_Rd710_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_SetConfig((phhalHw_Mp300_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_SetConfig((phhalHw_ISO3_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_SetConfig((phhalHw_Callback_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_SetConfig((phhalHw_SamAV2_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_SetConfig((phhalHw_SamAV3_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_SetConfig((phhalHw_Sam_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_SetConfig((phhalHw_RdCardSim_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_SetConfig((phhalHw_MfcCrypto_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_SetConfig((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_SetConfig((phhalHw_Rc632_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */
#ifdef NXPBUILD__PHHAL_HW_LICENSEEWRAPPER
        case PHHAL_HW_LICENSEEWRAPPER_ID:
            status = phhalHw_LicenseeWrapper_SetConfig((phhalHw_LicenseeWrapper_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_LICENSEEWRAPPER */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_SetConfig((phhalHw_Pcsc_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_SetConfig((phhalHw_ProxiLAB_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_SetConfig((phhalHw_DUT_DataParams_t *) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_MfcAuthenticateKeyNo(void * pDataParams, uint8_t bBlockNo, uint8_t bKeyType, uint16_t wKeyNo, uint16_t wKeyVersion,
    uint8_t * pUid)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_MfcAuthenticateKeyNo");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bBlockNo);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bKeyType);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wKeyNo);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wKeyVersion);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pUid);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bBlockNo_log, &bBlockNo);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bKeyType_log, &bKeyType);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wKeyNo_log, &wKeyNo);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wKeyVersion_log, &wKeyVersion);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pUid_log, pUid, 4);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pUid);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_MfcAuthenticateKeyNo((phhalHw_Rc663_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_MfcAuthenticateKeyNo((phhalHw_Rc523_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_MfcAuthenticateKeyNo((phhalHw_Rd70x_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_MfcAuthenticateKeyNo((phhalHw_Rd710_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_MfcAuthenticateKeyNo((phhalHw_Mp300_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_MfcAuthenticateKeyNo((phhalHw_ISO3_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_MfcAuthenticateKeyNo((phhalHw_Callback_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_MfcAuthenticateKeyNo((phhalHw_SamAV2_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_MfcAuthenticateKeyNo((phhalHw_SamAV3_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_MfcAuthenticateKeyNo((phhalHw_RdCardSim_DataParams_t *) pDataParams, bBlockNo,
                bKeyType, wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_MfcAuthenticateKeyNo((phhalHw_MfcCrypto_DataParams_t *) pDataParams, bBlockNo,
                bKeyType, wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_MfcAuthenticateKeyNo((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, bBlockNo,
                bKeyType, wKeyNo, wKeyVersion, pUid);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_MfcAuthenticateKeyNo((phhalHw_Rc632_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_MfcAuthenticateKeyNo((phhalHw_Pcsc_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_MfcAuthenticateKeyNo((phhalHw_ProxiLAB_DataParams_t *) pDataParams, bBlockNo,
                bKeyType, wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_MfcAuthenticateKeyNo((phhalHw_DUT_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                wKeyNo, wKeyVersion, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_MfcAuthenticate(void * pDataParams, uint8_t bBlockNo, uint8_t bKeyType, uint8_t * pKey, uint8_t * pUid)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_MfcAuthenticate");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bBlockNo);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bKeyType);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pKey);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pUid);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bBlockNo_log, &bBlockNo);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bKeyType_log, &bKeyType);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pKey_log, pKey, 6);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pUid_log, pUid, 4);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pKey);

    /* Variables not used */
    PH_UNUSED_VARIABLE(pUid);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_MfcAuthenticate((phhalHw_Rc663_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_MfcAuthenticate((phhalHw_Rc523_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_MfcAuthenticate((phhalHw_Rd70x_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_MfcAuthenticate((phhalHw_Rd710_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_MfcAuthenticate((phhalHw_Mp300_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_MfcAuthenticate((phhalHw_ISO3_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_MfcAuthenticate((phhalHw_Callback_DataParams_t *) pDataParams, bBlockNo, bKeyType,
                pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_MfcAuthenticate((phhalHw_SamAV2_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_MfcAuthenticate((phhalHw_SamAV3_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_MfcAuthenticate((phhalHw_RdCardSim_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey,
                pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_MfcAuthenticate((phhalHw_MfcCrypto_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey,
                pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_MfcAuthenticate((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey,
                pUid);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_MfcAuthenticate((phhalHw_Rc632_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_MfcAuthenticate((phhalHw_Pcsc_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_MfcAuthenticate((phhalHw_ProxiLAB_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey,
                pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_MfcAuthenticate((phhalHw_DUT_DataParams_t *) pDataParams, bBlockNo, bKeyType, pKey, pUid);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue)
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_GetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wConfig_log, &wConfig);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pValue);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_GetConfig((phhalHw_Rc663_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_GetConfig((phhalHw_Rc523_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_GetConfig((phhalHw_Rd70x_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_GetConfig((phhalHw_Rd710_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_GetConfig((phhalHw_Mp300_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_GetConfig((phhalHw_ISO3_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_GetConfig((phhalHw_Callback_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_GetConfig((phhalHw_SamAV2_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_GetConfig((phhalHw_SamAV3_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_GetConfig((phhalHw_Sam_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_GetConfig((phhalHw_RdCardSim_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_GetConfig((phhalHw_MfcCrypto_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_GetConfig((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_GetConfig((phhalHw_Rc632_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_LICENSEEWRAPPER
        case PHHAL_HW_LICENSEEWRAPPER_ID:
            status = phhalHw_LicenseeWrapper_GetConfig((phhalHw_LicenseeWrapper_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_LICENSEEWRAPPER */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_GetConfig((phhalHw_Pcsc_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_GetConfig((phhalHw_ProxiLAB_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_GetConfig((phhalHw_DUT_DataParams_t *) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, pValue_log, pValue);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_FieldOn(void * pDataParams)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_FieldOn");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_FieldOn((phhalHw_Rc663_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_FieldOn((phhalHw_Rc523_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_FieldOn((phhalHw_Rd70x_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_FieldOn((phhalHw_Rd710_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_FieldOn((phhalHw_Mp300_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_FieldOn((phhalHw_ISO3_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_FieldOn((phhalHw_Callback_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_FieldOn((phhalHw_SamAV2_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_FieldOn((phhalHw_SamAV3_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_FieldOn((phhalHw_Sam_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_FieldOn((phhalHw_RdCardSim_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_FieldOn((phhalHw_MfcCrypto_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_FieldOn((phhalHw_RdFpgaV6_DataParams_t *) pDataParams);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_FieldOn((phhalHw_Rc632_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_FieldOn((phhalHw_Pcsc_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_FieldOn((phhalHw_ProxiLAB_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_FieldOn((phhalHw_DUT_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_FieldOff(void * pDataParams)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_FieldOff");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_FieldOff((phhalHw_Rc663_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_FieldOff((phhalHw_Rc523_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_FieldOff((phhalHw_Rd70x_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_FieldOff((phhalHw_Rd710_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_FieldOff((phhalHw_Mp300_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_FieldOff((phhalHw_ISO3_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_FieldOff((phhalHw_Callback_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_FieldOff((phhalHw_SamAV2_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_FieldOff((phhalHw_SamAV3_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_FieldOff((phhalHw_Sam_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_FieldOff((phhalHw_RdCardSim_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_FieldOff((phhalHw_MfcCrypto_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_FieldOff((phhalHw_RdFpgaV6_DataParams_t *) pDataParams);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_FieldOff((phhalHw_Rc632_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_FieldOff((phhalHw_Pcsc_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_FieldOff((phhalHw_ProxiLAB_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_FieldOff((phhalHw_DUT_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_FieldReset(void * pDataParams)
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_FieldReset");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_FieldReset((phhalHw_Rc663_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_FieldReset((phhalHw_Rc523_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_FieldReset((phhalHw_Rd70x_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_FieldReset((phhalHw_Rd710_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_FieldReset((phhalHw_Mp300_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_FieldReset((phhalHw_ISO3_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_FieldReset((phhalHw_Callback_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_FieldReset((phhalHw_SamAV2_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_FieldReset((phhalHw_SamAV3_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_FieldReset((phhalHw_Sam_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_FieldReset((phhalHw_RdCardSim_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_FieldReset((phhalHw_MfcCrypto_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_FieldReset((phhalHw_RdFpgaV6_DataParams_t *) pDataParams);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_FieldReset((phhalHw_Rc632_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_FieldReset((phhalHw_Pcsc_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_LICENSEEWRAPPER
        case PHHAL_HW_LICENSEEWRAPPER_ID:
            status = phhalHw_LicenseeWrapper_FieldReset((phhalHw_LicenseeWrapper_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_LICENSEEWRAPPER */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_FieldReset((phhalHw_ProxiLAB_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_FieldReset((phhalHw_DUT_DataParams_t *) pDataParams);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_Wait(void * pDataParams, uint8_t bUnit, uint16_t wTimeout)
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_Wait");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bUnit);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wTimeout);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bUnit_log, &bUnit);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wTimeout_log, &wTimeout);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_RC663
        case PHHAL_HW_RC663_ID:
            status = phhalHw_Rc663_Wait((phhalHw_Rc663_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC663 */

#ifdef NXPBUILD__PHHAL_HW_RC523
        case PHHAL_HW_RC523_ID:
            status = phhalHw_Rc523_Wait((phhalHw_Rc523_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC523 */

#ifdef NXPBUILD__PHHAL_HW_RD70X
        case PHHAL_HW_RD70X_ID:
            status = phhalHw_Rd70x_Wait((phhalHw_Rd70x_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD70X */

#ifdef NXPBUILD__PHHAL_HW_RD710
        case PHHAL_HW_RD710_ID:
            status = phhalHw_Rd710_Wait((phhalHw_Rd710_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_RD710 */

#ifdef NXPBUILD__PHHAL_HW_MP300
        case PHHAL_HW_MP300_ID:
            status = phhalHw_Mp300_Wait((phhalHw_Mp300_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef NXPBUILD__PHHAL_HW_ISO3
        case PHHAL_HW_ISO3_ID:
            status = phhalHw_ISO3_Wait((phhalHw_ISO3_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_ISO3 */

#ifdef NXPBUILD__PHHAL_HW_CALLBACK
        case PHHAL_HW_CALLBACK_ID:
            status = phhalHw_Callback_Wait((phhalHw_Callback_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
        case PHHAL_HW_SAMAV2_ID:
            status = phhalHw_SamAV2_Wait((phhalHw_SamAV2_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
        case PHHAL_HW_SAMAV3_ID:
            status = phhalHw_SamAV3_Wait((phhalHw_SamAV3_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#ifdef NXPBUILD__PHHAL_HW_SAM
        case PHHAL_HW_SAM_ID:
            status = phhalHw_Sam_Wait((phhalHw_Sam_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_SAM */

#ifdef NXPBUILD__PHHAL_HW_RDCARDSIM
        case PHHAL_HW_RDCARDSIM_ID:
            status = phhalHw_RdCardSim_Wait((phhalHw_RdCardSim_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_RDCARDSIM */

#ifdef NXPBUILD__PHHAL_HW_MFCCRYPTO
        case PHHAL_HW_MFCCRYPTO_ID:
            status = phhalHw_MfcCrypto_Wait((phhalHw_MfcCrypto_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6
        case PHHAL_HW_RDFPGAV6_ID:
            status = phhalHw_RdFpgaV6_Wait((phhalHw_RdFpgaV6_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /*NXPBUILD__PHHAL_HW_RDFPGAV6*/

#ifdef NXPBUILD__PHHAL_HW_RC632
        case PHHAL_HW_RC632_ID:
            status = phhalHw_Rc632_Wait((phhalHw_Rc632_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_RC632 */

#ifdef NXPBUILD__PHHAL_HW_PCSC
        case PHHAL_HW_PCSC_ID:
            status = phhalHw_Pcsc_Wait((phhalHw_Pcsc_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_PCSC */

#ifdef NXPBUILD__PHHAL_HW_LICENSEEWRAPPER
        case PHHAL_HW_LICENSEEWRAPPER_ID:
            status = phhalHw_LicenseeWrapper_Wait((phhalHw_LicenseeWrapper_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_LICENSEEWRAPPER */

#ifdef NXPBUILD__PHHAL_HW_PROXILAB
        case PHHAL_HW_PROXILAB_ID:
            status = phhalHw_ProxiLAB_Wait((phhalHw_ProxiLAB_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_PROXILAB */

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_Wait((phhalHw_DUT_DataParams_t *) pDataParams, bUnit, wTimeout);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_I18000p3m3Inventory(void * pDataParams, uint8_t * pSelCmd, uint8_t bSelCmdLen, uint8_t bNumValidBitsinLastByte,
    uint8_t * pBeginRndCmd, uint8_t bTSprocessing, uint8_t ** ppRxBuffer, uint16_t * wRxBufferLen)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_I18000p3m3Inventory");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pSelCmd);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bNumValidBitsinLastByte);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bTSprocessing);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wRxBufferLen);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pBeginRndCmd);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pSelCmd);
    PH_ASSERT_NULL(pBeginRndCmd);
    PH_ASSERT_NULL(ppRxBuffer);
    PH_ASSERT_NULL(wRxBufferLen);

    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pSelCmd_log, pSelCmd, bSelCmdLen);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pBeginRndCmd_log, pBeginRndCmd, 3U);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bNumValidBitsinLastByte_log, &bNumValidBitsinLastByte);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bTSprocessing_log, &bTSprocessing);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);
        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_I18000p3m3Inventory((phhalHw_DUT_DataParams_t *) pDataParams, pSelCmd, bSelCmdLen,
                bNumValidBitsinLastByte, pBeginRndCmd, bTSprocessing, ppRxBuffer, wRxBufferLen);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

#ifdef NXPBUILD__PH_LOG
    if(ppRxBuffer != NULL)
    {
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wRxBufferLen_log, wRxBufferLen);
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *wRxBufferLen);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);

    return status;
}

phStatus_t phhalHw_I18000p3m3ResumeInventory(void * pDataParams, uint8_t ** ppRxBuffer, uint16_t * wRxBufferLen)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_I18000p3m3ResumeInventory");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wRxBufferLen);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(ppRxBuffer);
    PH_ASSERT_NULL(wRxBufferLen);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);
        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {

#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_I18000p3m3ResumeInventory((phhalHw_DUT_DataParams_t *) pDataParams, ppRxBuffer, wRxBufferLen);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */
        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

#ifdef NXPBUILD__PH_LOG
    if(ppRxBuffer != NULL)
    {
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wRxBufferLen_log, wRxBufferLen);
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *wRxBufferLen);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    return status;
}

phStatus_t phhalHw_ReadEEPROM(void * pDataParams, uint16_t wOption, uint32_t dwAddr_ProtIndex, uint32_t dwNoOfBytesToRead,
    uint8_t ** ppResponse, uint16_t * pRespLen)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_ReadEEPROM");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(dwAddr_ProtIndex);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(dwNoOfBytesToRead);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppResponse);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pRespLen);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wOption), &wOption);
    PH_LOG_HELPER_ADDPARAM_UINT32(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(dwAddr_ProtIndex), &dwAddr_ProtIndex);
    PH_LOG_HELPER_ADDPARAM_UINT32(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(dwNoOfBytesToRead), &dwNoOfBytesToRead);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_HAL);
    PH_ASSERT_NULL_PARAM(pRespLen, PH_COMP_HAL);
    PH_ASSERT_NULL_PARAM(pRespLen, PH_COMP_HAL);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_Cmd_RdOps_Read_EEPROM((phhalHw_DUT_DataParams_t *) pDataParams, wOption,
                dwAddr_ProtIndex, dwNoOfBytesToRead, ppResponse, pRespLen);
            break;
#endif /* NXPBUILD__PHHAL_HW_DUT */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(ppResponse), *ppResponse, *pRespLen);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(pRespLen), pRespLen);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHw_WriteEEPROM(void * pDataParams, uint16_t wOption, uint32_t dwStartAddr, uint8_t * pData,
    uint16_t wDataLen)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHw_WriteEEPROM");

    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(dwStartAddr);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pData);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wDataLen);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wOption), &wOption);
    PH_LOG_HELPER_ADDPARAM_UINT32(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(dwStartAddr), &dwStartAddr);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(pData), pData, wDataLen);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wDataLen), &wDataLen);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_DUT
        case PHHAL_HW_DUT_ID:
            status = phhalHw_DUT_Cmd_RdOps_Write_EEPROM((phhalHw_DUT_DataParams_t *) pDataParams, wOption,
                dwStartAddr, pData, wDataLen);
            break;
#endif /* PHHAL_HW_DUT_ID */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

#endif /* NXPBUILD__PHHAL_HW */
