/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/*
 * Transparent specific HAL-Component of Reader Library Framework.
 * $RCSfile $
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifdef _WIN32

#ifndef PHHALHW_CONTACT_KEOLABS_H
#define PHHALHW_CONTACT_KEOLABS_H

#include <ph_Status.h>
#include <phhalHwContact.h>

phStatus_t phhalHwContact_Keolabs_SetConfig32(
    phhalHwContact_Keolabs_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint32_t dwValue
    );

phStatus_t phhalHwContact_Keolabs_GetConfig32(
    phhalHwContact_Keolabs_DataParams_t * pDataParams,
    uint16_t   wConfig,
    uint32_t * pValue
    );

phStatus_t phhalHwContact_Keolabs_Wait(
    phhalHwContact_Keolabs_DataParams_t * pDataParams,
    uint8_t   bUnit,
    uint16_t  wTimeout
    );

phStatus_t phhalHwContact_Keolabs_Exchange(
    phhalHwContact_Keolabs_DataParams_t * pDataParams,
    uint16_t    wOption,
    uint8_t   * pTxBuffer,
    uint16_t    wTxLength,
    uint8_t  ** ppRxBuffer,
    uint16_t  * pRxLength
    );

phStatus_t phhalHwContact_Keolabs_ApplyProtocolSettings(
    phhalHwContact_Keolabs_DataParams_t * pDataParams,
    uint8_t * pAtr,
    uint16_t dwAtrLength,
    uint8_t bProtocolType
    );

phStatus_t phhalHwContact_Keolabs_Activate(
    phhalHwContact_Keolabs_DataParams_t * pDataParams,
    uint8_t * pATRBuffer,
    uint16_t * pwATRLength
    );

phStatus_t phhalHwContact_Keolabs_Deactivate(
    phhalHwContact_Keolabs_DataParams_t * pDataParams
    );

phStatus_t phhalHwContact_Keolabs_ClockStop(
    phhalHwContact_Keolabs_DataParams_t * pDataParams,
    uint16_t wTgClockCount,
    uint16_t wThClockCount,
    uint32_t dwPinState
    );

phStatus_t phhalHwContact_Keolabs_InitContactReader(
    phhalHwContact_Keolabs_DataParams_t * pDataParams
    );

#endif /* PHHALHW_CONTACT_KEOLABS_H */
#endif

