/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for CONTACT_MICROPROSS specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_CONTACT_KEOLABS_INT_H
#define PHHALHW_CONTACT_KEOLABS_INT_H

#include <ph_Status.h>

#ifdef __cplusplus
extern "C" {
#endif

phStatus_t phhalHwContact_Keolabs_Int_ConvertError(
                                                   uint32_t status
                                                   );

phStatus_t phhalHwContact_Keolabs_Int_SetVcc(
                                             phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                             uint32_t vcc
                                             );

phStatus_t phhalHwContact_Keolabs_Int_SetClk(
                                             phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                             uint32_t clk
                                             );

phStatus_t phhalHwContact_Keolabs_Int_SetDelay(
                                               phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                               uint32_t delay
                                               );

phStatus_t phhalHwContact_Keolabs_Int_ResetReader(
                                                  phhalHwContact_Keolabs_DataParams_t * pDataParams
                                                  );

phStatus_t phhalHwContact_Keolabs_Int_Activate(
                                               phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                               uint8_t * pATRBuffer,
                                               uint16_t * pwATRLength
                                               );

phStatus_t phhalHwContact_Keolabs_Int_Deactivate(
                                                 phhalHwContact_Keolabs_DataParams_t * pDataParams
                                                 );

phStatus_t phhalHwContact_Keolabs_Int_TransparentCommand(
                                                         phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                                         uint8_t    * pTxBuffer,
                                                         uint16_t     wTxLength,
                                                         uint8_t   ** pRxBuffer,
                                                         uint16_t   * wRxLength,
                                                         uint16_t     wRxBuffSize
                                                         );

phStatus_t phhalHwContact_Keolabs_Int_SetFdValue(
                                                 phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                                 uint8_t bFdValue
                                                 );

phStatus_t phhalHwContact_Keolabs_Int_GetConvention(
                                                    phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                                    uint8_t * bConvention
                                                    );

phStatus_t phhalHwContact_Keolabs_Int_SetTimingParameter(
                                                         phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                                         uint16_t wConfig,
                                                         uint32_t dwValue
                                                         );

phStatus_t phhalHwContact_Keolabs_Int_GetTimingParameter(
                                                         phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                                         uint16_t wConfig,
                                                         uint32_t * pValue
                                                         );

phStatus_t phhalHwContact_Keolabs_Int_GetIfscValue(
                                                   phhalHwContact_Keolabs_DataParams_t * pDataParams,
                                                   uint32_t * pValue
                                                   );

#ifdef __cplusplus
}
#endif
#endif /* PHHALHW_CONTACT_KEOLABS_INT_H */
