/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic Contact HAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_CONTACT_MICROPROSS_H
#define PHHALHW_CONTACT_MICROPROSS_H

#include <ph_Status.h>
#include <phhalHwContact.h>

phStatus_t phhalHwContact_Micropross_Exchange(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wOption,                                       /**< [In] Option parameter. */
    uint8_t * pTxBuffer,                                    /**< [In] Data to transmit. */
    uint16_t wTxLength,                                     /**< [In] Number of bytes to transmit. */
    uint8_t ** ppRxBuffer,                                  /**< [Out] Pointer to received data. */
    uint16_t * pRxLength                                    /**< [Out] Number of received data bytes. */
    );

phStatus_t phhalHwContact_Micropross_ApplyProtocolSettings(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t * pAtr,                                         /**< [In] Atr Buffer with Settings to apply (if not Atr given default is applied). */
    uint16_t dwAtrLength,                                   /**< [In] Length of the given Atr Buffer. */
    uint8_t bProtocolType                                   /**< [In] Type of protocol for which the HAL should be configured for. */
    );

phStatus_t phhalHwContact_Micropross_SetConfig32(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wConfig,                                       /**< [In] Configuration Identifier. */
    uint32_t dwValue                                        /**< [In] Configuration Value. */
    );

phStatus_t phhalHwContact_Micropross_GetConfig32(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wConfig,                                       /**< [In] Configuration Identifier. */
    uint32_t * pdwValue                                     /**< [Out] Configuration Value. */
    );

phStatus_t phhalHwContact_Micropross_Activate(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t * pATRBuffer,                                   /**< [Out] Data to the received ATR. */
    uint16_t * pwATRLength                                  /**< [Out] Length of the reiceived ATR. */
    );

phStatus_t phhalHwContact_Micropross_Deactivate(
    phhalHwContact_Micropross_DataParams_t * pDataParams    /**< [In] Pointer to this layer's parameter structure. */
    );

phStatus_t phhalHwContact_Micropross_ClockStop(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wTgClockCount,                                 /**< [In] Number of clock cycles while the clock must be kept running after the I/O line remains at Z state before stopping the clock (default is 1,860). Maximum value is 65,535 clock cycles. */
    uint16_t wThClockCount,                                 /**< [In] Number of clock cycles before the exchange on the I/O line after a clock resume. */
    uint32_t dwPinState                                     /**< [In] The desired state of the clock. If CLOCK_STOP_HIGH or CLOCK_CTOP_LOW is ored with CLOCK_AUTO_OFF (0x80000000), the clock will be automatically switched off after each APDU. */
    );

phStatus_t phhalHwContact_Micropross_Wait(
    phhalHwContact_Micropross_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t bUnit,                                          /**< [In] Unit of given timeout value (either #PHHAL_HW_CONTACT_TIME_MICROSECONDS or #PHHAL_HW_CONTACT_TIME_MILLISECONDS). */
    uint16_t wTimeout                                       /**< [In] Timeout value. */
    );

phStatus_t phhalHwContact_Micropross_InitContactReader(
    phhalHwContact_Micropross_DataParams_t * pDataParams    /**< [In] Pointer to this layer's parameter structure. */
    );

#endif /* PHHALHW_CONTACT_MICROPROSS_H */
