/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for CONTACT_MICROPROSS specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_CONTACT_MICROPROSS_INT_H
#define PHHALHW_CONTACT_MICROPROSS_INT_H

#include <ph_Status.h>

#define PHHAL_HW_CONTACT_MICROPROSS_COM_TIMEOUT_OFFSET_MS  5000U    /**< Additional Timeout used for the BAL. */

#define CONTACT_MICROPROSS_USB_PORT                         (uint8_t *)"USB:102"
#define CONTACT_MICROPROSS_TCPIP_PORT                       (uint8_t *)"61641"

#define CONTACT_MICROPROSS_CMD_EXCHANGE                     (uint8_t *)"CPSR"
#define CONTACT_MICROPROSS_CMD_ISON                         (uint8_t *)"ISON"
#define CONTACT_MICROPROSS_CMD_ISOF                         (uint8_t *)"ISOF"
#define CONTACT_MICROPROSS_CMD_CLK_STOP                     (uint8_t *)"CPCS"
#define CONTACT_MICROPROSS_CMD_GET_VERSION                  (uint8_t *)"HELO"
#define CONTACT_MICROPROSS_CMD_GET_EEPROM_SYS               (uint8_t *)"EEGS"
#define CONTACT_MICROPROSS_CMD_GET_COUPLER_INFO             (uint8_t *)"HEHM"
#define CONTACT_MICROPROSS_CMD_COUPLER_EEPROM_SYS           (uint8_t *)"EECS"
#define CONTACT_MICROPROSS_CMD_EEPROM_C_READ                (uint8_t *)"EECR"
#define CONTACT_MICROPROSS_CMD_COUPLER_CHECK_LICENSE        (uint8_t *)"EECL"
#define CONTACT_MICROPROSS_CMD_RESET_HARD                   (uint8_t *)"RSTH"

/* Resource Commands */
#define CONTACT_MICROPROSS_CMD_OPEN_RESSOURCE               (uint8_t *)"RMOP"
#define CONTACT_MICROPROSS_CMD_CLOSE_RESSOURCE              (uint8_t *)"RMCL"

/* Info Commands */
#define CONTACT_MICROPROSS_CMD_GET_COUPLER_INFO             (uint8_t *)"HEHM"
#define CONTACT_MICROPROSS_CMD_GET_RESOURCE_ID              (uint8_t *)"GTRI"

/* Other */
#define CONTACT_MICROPROSS_CMD_DO_TEMPO                     (uint8_t *)"DOTP"
#define CONTACT_MICROPROSS_CMD_SPY_OPEN                     (uint8_t *)"LGOP"
#define CONTACT_MICROPROSS_CMD_SPY_CLOSE                    (uint8_t *)"LGCL"
#define CONTACT_MICROPROSS_CMD_CLK_FREQUENCY                (uint8_t *)"CPFS"
#define CONTACT_MICROPROSS_CMD_VOLTAGE_CLASS                (uint8_t *)"SVCM"
#define CONTACT_MICROPROSS_CMD_PROTOCOL_PARAM               (uint8_t *)"CPCP"
#define CONTACT_MICROPROSS_CMD_PROTOCOL_PARAM_GET           (uint8_t *)"CPGP"
#define CONTACT_MICROPROSS_CMD_PULLUPRES                    (uint8_t *)"CPPL"
#define CONTACT_MICROPROSS_CMD_SETFALLRISETIME              (uint8_t *)"SVRT"
#define CONTACT_MICROPROSS_CMD_SETVOLVOH                    (uint8_t *)"SVOU"
#define CONTACT_MICROPROSS_CMD_SETVILVIH                    (uint8_t *)"SVIN"
#define CONTACT_MICROPROSS_CMD_SETDUTYCYCLE                 (uint8_t *)"CPDC"
#define CONTACT_MICROPROSS_CMD_OPEN_LOG                     (uint8_t *)"CPOL"
#define CONTACT_MICROPROSS_CMD_CLOSE_LOG                    (uint8_t *)"CPCL"
#define CONTACT_MICROPROSS_CMD_END_DOWNLOAD                 (uint8_t *)"LGED"
#define CONTACT_MICROPROSS_CMD_FLUSH_LOG                    (uint8_t *)"CPFL"
#define CONTACT_MICROPROSS_CMD_LAUNCH_DOWNLOAD              (uint8_t *)"LGBD"
#define CONTACT_MICROPROSS_CMD_SPY_DATE_FORMAT              (uint8_t *)"LGCM"
#define CONTACT_MICROPROSS_CMD_GET_RESPONSE_TIME            (uint8_t *)"CPGT"
#define CONTACT_MICROPROSS_CMD_SET_GUARD_TIME_CLK           (uint8_t *)"CPSK"
#define CONTACT_MICROPROSS_CMD_SET_CONVENTION               (uint8_t *)"CPSC"
#define CONTACT_MICROPROSS_CMD_GET_NETWORK_INFO             (uint8_t *)"NMGA"

/* Sequencer */
#define CONTACT_MICROPROSS_CMD_SEQUENCER_OPEN               (uint8_t *)"SEOP"
#define CONTACT_MICROPROSS_CMD_SEQUENCER_EXECUTE            (uint8_t *)"SEEX"
#define CONTACT_MICROPROSS_CMD_SEQUENCER_ADD                (uint8_t *)"SEAD"
#define CONTACT_MICROPROSS_CMD_SEQUENCER_CLOSE              (uint8_t *)"SECL"

/* I2C */
#define CONTACT_MICROPROSS_CMD_I2C_OPEN                     (uint8_t *)"I2OP"
#define CONTACT_MICROPROSS_CMD_I2C_CLOSE                    (uint8_t *)"I2CL"
#define CONTACT_MICROPROSS_CMD_I2C_FLUSH                    (uint8_t *)"I2FL"
#define CONTACT_MICROPROSS_CMD_I2C_ON                       (uint8_t *)"I2ON"
#define CONTACT_MICROPROSS_CMD_I2C_OFF                      (uint8_t *)"I2OF"
#define CONTACT_MICROPROSS_CMD_I2C_PIN_WRITE                (uint8_t *)"CPWP"
#define CONTACT_MICROPROSS_CMD_I2C_WRITE                    (uint8_t *)"I2WR"
#define CONTACT_MICROPROSS_CMD_I2C_READ                     (uint8_t *)"I2RD"
#define CONTACT_MICROPROSS_CMD_I2C_CHANGE_PARAMETERS        (uint8_t *)"I2CP"

#define CONTACT_MICROPROSS_TRACEFILE_EXTENSION              (uint8_t *)".mplog"

#define CONTACT_MICROPROSS_RESSOURCE_BLOCKING               0x1
#define CONTACT_MICROPROSS_RESSOURCE_NOT_BLOCKING           0x0
#define CONTACT_MICROPROSS_RESSOURCE_CONCURRENT             0x2
#define CONTACT_MICROPROSS_RESSOURCE_OVERRIDE               0x3

#define CONTACT_MICROPROSS_MP_COUPLER_0                     0x00
#define CONTACT_MICROPROSS_MP_COUPLER_1                     0x01
#define CONTACT_MICROPROSS_MP_COUPLER_2                     0x02
#define CONTACT_MICROPROSS_MP_COUPLER_3                     0x03

#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_ADDRESS_WIDTH 1
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_RX_TIMEOUT    2
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_TX_TIMEOUT    3
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_TSU_DAT       4
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_THD_DAT       5
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_TSU_STA       6
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_THD_STA       7
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_TSU_STO       8
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_THIGH_SCL     9
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_TLOW_SCL      10
#define CONTACT_MICROPROSS_CMD_I2C_PARAMETER_I2C_CP_AUTO_NACK     11

#define CONTACT_MICROPROSS_I2C_CP_ADDRESS_7BIT_WIDTH               0 /**< 7bit I2C address */
#define CONTACT_MICROPROSS_I2C_CP_ADDRESS_10BIT_WIDTH              1 /**< 10bit I2C address */
#define CONTACT_MICROPROSS_I2C_CP_MAX_TIMEOUT_MS                   60000 /**< Maximum I2C timeout */
#define CONTACT_MICROPROSS_I2C_CP_MAX_TIMEING_NS                   65536 /**< Maximum values for I2C timings */
#define CONTACT_MICROPROSS_I2C_CP_TIMEING_RESOLUTION_NS            20    /**< Resolution if the I2C timings */


#define CONTACT_MICROPROSS_EVENT_MASK_FDT                   0x00000080

#define CONTACT_MICROPROSS_HEADER_SIZE                      8
#define CONTACT_MICROPROSS_SPY_HEADER_V1_SIZE               114
#define CONTACT_MICROPROSS_SPY_HEADER_V2_SIZE               116
#define CONTACT_MICROPROSS_SPY_HEADER_V3_SIZE               123
#define CONTACT_MICROPROSS_SPY_HEADER_V4_SIZE               124
#define CONTACT_MICROPROSS_SPY_HEADER_V5_SIZE               128

#define CONTACT_MICROPROSS_THREAD_TIMEOUT                   30000

/* GET_EEPROM_SYS Parameter IDs */
#define CONTACT_MICROPROSS_PARAMETER_GET_EEPROM_SYS_EEP_SERIAL_NUMBER           1      /**< Parameter ID to get the serial number. */
#define CONTACT_MICROPROSS_PARAMETER_GET_EEPROM_SYS_EEP_ETHERNET_ADDR           2      /**< Parameter ID to get the ethernet addess. */
#define CONTACT_MICROPROSS_PARAMETER_GET_EEPROM_SYS_EEP_UC_IDENT                3      /**< Parameter ID to get the uc ident. */

/* CouplerEepromSys Parameter IDs */
#define CONTACT_MICROPROSS_PARAMETER_COUPLER_EEPROM_SYS_EEP_COUPLER_IDENT       1      /**< Parameter ID to get the coupler serial number. */
#define CONTACT_MICROPROSS_PARAMETER_COUPLER_EEPROM_SYS_EEP_COUPLER_REVISION    2      /**< Parameter ID to get the coupler revision. */

#define CONTACT_MICROPROSS_SPY_BUFFER_SIZE                                      4096   /**< Size of Buffers in Spy Thread */

phStatus_t phhalHwContact_Micropross_Int_Sleep(
    phhalHwContact_Micropross_DataParams_t * pDataParams,       /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwTime                                             /**< [In] time to wait in usec. */
    );

phStatus_t phhalHwContact_Micropross_Int_SetClkFrequency(
    phhalHwContact_Micropross_DataParams_t * pDataParams,
    uint32_t dwClkFrequency
    );

phStatus_t phhalHwContact_Micropross_Int_SetVoltageClass(
    phhalHwContact_Micropross_DataParams_t * pDataParams,
    uint32_t dwVoltage
    );

phStatus_t phhalHwContact_Micropross_Int_I2CChangeParameter(
                                                          phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                          uint32_t dwConfig,
                                                          uint32_t dwParam1,
                                                          uint32_t dwParam2
                                                          );

phStatus_t phhalHwContact_Micropross_Int_SetProtocolParameter(
                                                          phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                          uint32_t dwConfig,
                                                          uint32_t dwValue
                                                          );

phStatus_t phhalHwContact_Micropross_Int_GetProtocolParameter(
                                                          phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                          uint32_t dwConfig,
                                                          uint32_t * pValue
                                                          );

phStatus_t phhalHwContact_Micropross_Int_GetIccResponseTimeNs(phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                            uint32_t * pResponseTime
                                                            );

phStatus_t phhalHwContact_Micropross_Int_SetPullUpResistor(phhalHwContact_Micropross_DataParams_t * pDataParams,
                                            uint32_t dwValue
                                            );

phStatus_t phhalHwContact_Micropross_Int_SetFallRiseTime(phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                     uint16_t wConfig,
                                                     uint32_t dwValue
                                                     );

phStatus_t phhalHwContact_Micropross_Int_SetOutVoltLowHigh(phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                       uint16_t wConfig,
                                                       uint32_t dwValue
                                                       );

phStatus_t phhalHwContact_Micropross_Int_SetDutyCycle(phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                   uint32_t dwValue
                                                   );

phStatus_t phhalHwContact_Micropross_Int_SetInVoltLowHigh(phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                   uint16_t wConfig,
                                                   uint32_t dwValue
                                                   );

phStatus_t phhalHwContact_Micropross_Int_ShadowDefaultPinValues(phhalHwContact_Micropross_DataParams_t * pDataParams);

phStatus_t phhalHwContact_Micropross_Int_EnableSpy(phhalHwContact_Micropross_DataParams_t * pDataParams, uint32_t dwEventMask, uint16_t wDateFormat);

phStatus_t phhalHwContact_Micropross_Int_DisableSpy(phhalHwContact_Micropross_DataParams_t * pDataParams);

phStatus_t phhalHwContact_Micropross_Int_ProcessData(
                                                     phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                     uint32_t DataType,
                                                     uint32_t Size, uint8_t *pData,
                                                     uint32_t *pSpyEvents,
                                                     uint32_t *gHeader,
                                                     uint8_t *pbFinished
                                                     );

unsigned long __stdcall phhalHwContact_Micropross_Int_ReadSpyDataThread (void *voidParams);

phStatus_t phhalHwContact_Micropross_Int_CalcOneETUns(phhalHwContact_Micropross_DataParams_t * pDataParams, uint32_t * pValue);

uint16_t phhalHwContact_Micropross_Int_EvaluateData(
                                                    phhalHwContact_Micropross_DataParams_t *pDataParams,
                                                    int32_t dwReceivedBytes,
                                                    uint32_t *gHeader,
                                                    uint32_t *pSpyEvents,
                                                    uint8_t *pRxBuffer,
                                                    uint8_t *pData,
                                                    uint32_t *dwDataOffset,
                                                    uint32_t *remainingSize,
                                                    uint32_t *DataType,
                                                    uint32_t *Size,
                                                    uint32_t *dwETUns,
                                                    uint8_t *bDataTypeReceived,
                                                    uint8_t *bSizeReceived
                                                    );

phStatus_t phhalHwContact_Micropross_Int_FinishSpying(
                                                      phhalHwContact_Micropross_DataParams_t *pDataParams,
                                                      uint32_t *pSpyEvents,
                                                      uint32_t *gHeader,
                                                      uint32_t *dwETUns
                                                      );

phStatus_t phhalHwContact_Micropross_Int_SimAtrString(
                                                    phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                    uint8_t * pAtrString
                                                    );

phStatus_t phhalHwContact_Micropross_Int_SetGuardTimeClk(
                                                    phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                    uint32_t dwEtuCount,
                                                    uint32_t dwClockCount
                                                    );

phStatus_t phhalHwContact_Micropross_Int_SetConvention(
                                                       phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                       uint32_t dwConvention
                                                       );

phStatus_t phhalHwContact_Micropross_Int_ResetHard(
                                                   phhalHwContact_Micropross_DataParams_t * pDataParams
                                                   );

phStatus_t phhalHwContact_Micropross_Int_ActivateI2C(
                                                     phhalHwContact_Micropross_DataParams_t * pDataParams
                                                     );

phStatus_t phhalHwContact_Micropross_Int_DeactivateI2C(
                                                       phhalHwContact_Micropross_DataParams_t * pDataParams
                                                       );

phStatus_t phhalHwContact_Micropross_Int_GetMpNetworkAddress(
                                                             phhalHwContact_Micropross_DataParams_t * pDataParams,
                                                             uint32_t * NetworkAddress,
                                                             uint32_t * SubnetMask
                                                             );

#endif /* PHHALHW_CONTACT_MICROPROSS_INT_H */
