/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * MP300 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2

#include "phhalHwContact_RdScr2.h"
#include "phhalHwContact_RdScr2_Int.h"
#include <phTools.h>

phStatus_t phhalHwContact_RdScr2_Int_ConvertError(
                                                   uint32_t status
                                                   )
{
    switch (status)
    {
    case SCR2_OK:
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);

    case SCR2_E_INITIALIZE:
    case SCR2_E_ENUMERATE :
    case SCR2_E_SHAREDMEMORY:
    case SCR2_E_SERIAL_ERROR:
    case SCR2_E_READER_NOT_FOUND:
    case SCR2_E_SERIAL_NOT_FOUND:
    case SCR2_E_NOT_INITIALIZED:
    case SCR2_E_ALREADY_INITIALIZED:
    case SCR2_E_READ_REGISTER:
    case SCR2_E_WRITE_REGISTER:
    case SCR2_E_READ_MEMORY:
    case SCR2_E_WRITE_MEMORY:
    case SCR2_E_SET_TIMEOUT:
    case SCR2_E_TSENS_NOT_ENABLED:
    case SCR2_E_TSENS_ERROR:
    case SCR2_E_CONTROL_IO_PORTS:
    case SCR2_E_FATALERROR:
    case SCR2_E_EXCEPTION:
    case SCR2_E_TRACEERROR:
    case SCR2_E_TRACEINCONSISTENT:
    case SCR2_E_TRACEFILE:
    case SCR2_E_LOGGERISACTIVE:
    case SCR2_E_LOGGERNOTSTARTED:
    case SCR2_E_LOGGERNOTSTOPPED:
    case SCR2_E_LOGGEROVERFLOW:
    case SCR2_E_GENERALHCIERROR:
    case SCR2_E_CONTROL_TRAPDOOR:
    case SCR2_E_FEATURENOTSUPPORTED:
    case SCR2_E_PORTNOTAVAILABLE:
    case SCR2_E_COMMIFNOTENABLED:
    case SCR2_E_COMMIFNOTSELECTED:
    case SCR2_E_DUALIFNOTSELECTED:
    case SCR2_E_WRONG_VTP_VALUE:
    case SCR2_E_COMMIF1NOTAVAILABLE:
    case SCR2_E_COMMIF2NOTAVAILABLE:
    case SCR2_E_GTKWFILE:
    case SCR2_E_SUPPORT_DLL_NOT_FOUND:
    case SCR2_E_TRIM_WRITE:
    case SCR2_E_MEASUREMENT_DISABLED:
    case SCR2_E_DISPLAYSTRING_TOO_LONG:
    case SCR2_E_WRONG_VCC_VALUE:
    case SCR2_E_CLOCK1_ERROR:
    case SCR2_E_CLOCK2_ERROR:
    case SCR2_E_ABORTED_BY_USER:
    case SCR2_E_MEMORY_ALLOCATION_FAILED:
    case SCR2_E_LOGFILE_ERROR:
    case SCR2_E_LOGFILE_NOT_OPEN:
    case SCR2_E_TRIGGERPORTNOTAVAILABLE:
    case SCR2_E_IDENT_CRC_ERROR:
    case SCR2_E_IDENT_NOT_FOUND:
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_HAL);

    case SCR2_E_PARAM_ERROR:
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_HAL);

    case SCR2_E_ISO7816_STOPBIT_ERROR:
    case SCR2_E_ISO7816_TIMEOUT:
    case SCR2_E_RAWI2C_STRETCH_TIMEOUT:
    case SCR2_E_RAWI2C_NOT_ACKNOWLEDGED:
    case SCR2_E_T1SPI_TIMEOUT:
        return PH_ADD_COMPCODE(PH_ERR_IO_TIMEOUT, PH_COMP_HAL);

    case SCR2_E_TDA_UNUSED:
    case SCR2_E_TDA_CONSISTENCY_ERROR:
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_HAL);

    default:
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_HAL);
    }
}

#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */
