/************************************************************************
			DES 
 This optimized 3DES implementation conforms to FIPS-46-3
 **********************************************************************
 Copyright (c) SMARTWARE, 1999-2005 All Rights Reserved.
 ************************************************************************
 27/06/2005 ML,SM V2R01 : Creation from freeware
 ************************************************************************/
#ifndef des_h
#define des_h

#include <err.h>

#ifdef __cplusplus
extern "C" {
#endif
/************************************************************************
			DES (simple)
 ************************************************************************/
#define des_ModeEncrypt  0
#define des_ModeDecrypt  1

typedef struct {
    ulong	RFU[4];		// Reserved to the system
    ulong	esk[32];     // DES encryption subkeys 
    ulong	dsk[32];     // DES decryption subkeys 
  } des_1ObjType;
/*----------------------------------------------------------------------*
                        Define Key
 *----------------------------------------------------------------------*/
extern
err_Type des_1KeyLoad(
        des_1ObjType * Obj, 
        uchar key[8]
        );
/*----------------------------------------------------------------------*
                Des Crypto with loaded Key
 *----------------------------------------------------------------------*/
extern
err_Type des_1Crypto(
        des_1ObjType * Obj, 
        int Mode,	// Cipher, Decipher
        uchar DataIn[8],	// Value (8)
        uchar DataOut[8]	// OUT : Result (8)
        );
/************************************************************************
                        DES (Triple)
 ************************************************************************/
typedef struct {
    ulong	RFU[4];		// Reserved to the system
    ulong	esk[96];	// Triple-DES encryption subkeys
    ulong	dsk[96];	// Triple-DES decryption subkeys
  } des_3ObjType;

/*----------------------------------------------------------------------*
                        Define Keys
 *----------------------------------------------------------------------*/
// 2 keys
extern
err_Type des_3KeyLoad2(
        des_3ObjType * Obj, 
        uchar key1[8], 
        uchar key2[8]
        );
// 3 keys
extern
err_Type des_3KeyLoad3(
        des_3ObjType * Obj, 
        uchar key1[8], 
        uchar key2[8],
        uchar key3[8]
        );
/*----------------------------------------------------------------------*
                Des Crypto with loaded Keys
 *----------------------------------------------------------------------*/
extern
err_Type des_3Crypto(
        des_3ObjType * Obj, 
        int Mode,		// Encrypt, decrypt
        uchar DataIn[8],	// Value
        uchar DataOut[8]	// OUT : Result
        );
/************************************************************************
                        DES (simple) No context
 Obsolete interface
 ************************************************************************/
/*---------------------------------------------------------------------*
        Load Key
 *---------------------------------------------------------------------*/
extern
err_Type des_KeyLoad(
        uchar  *K	// Length = 8
        );
/*----------------------------------------------------------------------*
                Des Crypto with loaded Key
 *----------------------------------------------------------------------*/
#define des_ModeCipher   0
#define des_ModeDecipher 1

extern
err_Type des_Crypto(
        int Mode,
        uchar *DataIn,	// Value (8)
        uchar *DataOut	// OUT : Result (8)
        );
/************************************************************************/

#ifdef __cplusplus
}
#endif
#endif
