/***********************************************************************
                FILE
		Interface of files
 ***********************************************************************
 22/05/2009 Marc LEGOUX V2R24a: Add Mode EOF
 25/01/2005 Marc LEGOUX V1R01 : Creation
 ***********************************************************************/
#ifndef file_h
#define file_h

#include <err.h>
#include <systf.h>	// For errors and Infos
#include <drv.h>

#ifdef __cplusplus
extern "C" {
#endif

#define file__EOF	syst__FileEOF
/*---------------------------------------------------------------------*/
#define file_FSType	void		// Handle type of File system driver
#define file_FSRef	void*		// Handle type of File system driver
#define file_Type	void		// Handle type of File
#define file_Ref	void*		// Handle of File

#define file_ClassName	"FILE"		// Class spec name
/*---------------------------------------------------------------------*
 			MODES
 *---------------------------------------------------------------------*/
// All modes in drv_ModeMaskX
#define file_ModeNew		0x00010000	// Create file if it does not exist
#define file_ModeOpenR		0x00020000	// Open for Read
#define file_ModeOpenW		0x00040000	// Open for Write
#define file_ModeOpenA		0x00080000	// Open for Append
#define file_ModeClear		0x00100000	// Overwrite the file and clear attributes

#define file_ModeOpenMask	0x000E0000	// Open Mask
#define file_ModeMask		0x00FF0000	// Mask
/*----------------------------------------------------------------------*
			Attributes
 *----------------------------------------------------------------------*/
#define file_AttrNormal		0x0000	// Normal
#define file_AttrArchive	0x0001	// Archive
#define file_AttrSystem		0x0002	// System
#define file_AttrHidden		0x0004	// Hidden
#define file_AttrReadOnly	0x0008	// ReadOnly
#define file_AttrDir		0x0100	// Directory
#define file_AttrMask		0x0FFF	// Mask

/************************************************************************
			File systems
 ************************************************************************/
// OBN Class file_FS BEGIN IdNum=102, Inherit=drv_Class, Mode=E
// Access like a pac entry (Mode=E)
/*--------------------------------------------------------------------*
                Create / Find file object
 *--------------------------------------------------------------------*/
extern
err_Type file_FSFileCreate( 
        file_FSRef This0,	// Handle of file system (0 for current)
        ulong	Mode,		// Mode
        ulong	Attr,		// File attributes
        file_Ref* pFile,	// OBN OUT, Length=1 : File handle
        char * Path		// OBN IN, Length=256: File Path in FS
        );
/*----------------------------------------------------------------------*/
// OBN Class file_FS END
/************************************************************************
			File objects
 ************************************************************************/
// OBN Class file BEGIN IdNum=103
/*--------------------------------------------------------------------*
                Read
 *--------------------------------------------------------------------*/
extern
err_Type file_Read( 
        file_Ref This0,	// File handle
        ulong	Mode,		// Mode
        ulong	Len,		// Number of bytes to read
        ulong	* pLen,		// OBN OUT, Length=1 : Number of bytes read
        char	* Buf		// OBN OUT, Length=Len : Buffer of bytes
        );
/*--------------------------------------------------------------------*
                Write
 *--------------------------------------------------------------------*/
extern
err_Type file_Write( 
        file_Ref This0,	// File handle
        ulong	Mode,		// Mode
        ulong	Len,		// Number of bytes to write
        ulong	* pLen,		// OBN OUT, Length=1 : Number of bytes written
        char	* Buf		// OBN IN, Length=Len : Buffer of bytes
        );
/*--------------------------------------------------------------------*
                File pointer Get/Set
 Only get if OffsL==OffsH==0 and Mode==Current
 *--------------------------------------------------------------------*/
#define file_PointerModeCurrent	0	// Offset from current
#define file_PointerModeBegin	1	// Offset from beginning
#define file_PointerModeEnd	2	// Offset from end
#define file_PointerModePosMask	3	// Position mask

#define file_PointerModeOffsH	0x20	// Returns high offset (else low)
#define file_PointerModeEOF	0x40	// Returns the distance of EOF 

extern
err_Type file_Pointer( 
        file_Ref This0,	// File handle
        ulong	Mode,		// Mode
        long	OffsL,		// Signed Low offset
        long	OffsH,		// Signed High offset
        long	* pOffs		// OBN OUT, Length=1 : null or return Offset
        );
/*--------------------------------------------------------------------*
                Info Get
 *--------------------------------------------------------------------*/
#define file_InfoType syst_FileInfoType
extern
err_Type file_InfoGet( 
        file_Ref This0,	// File handle
        ulong	Mode,		// Mode
        file_InfoType * Info	// OBN OUT, Length=1 : File infos
        );
/*----------------------------------------------------------------------*/
// OBN Class file END
/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
                        Create file from extended Path
 Path = 
 ":Stations:<StationName>:<FilePath>"	: Remote file
 "<FilePath>"				: Local file
 "@<Addr(08X)>"				: Local memory file (8 hexa digits)
 *----------------------------------------------------------------------*/
extern
err_Type file_Create( 
        ulong	Mode,		// Mode
        ulong	Attr,		// File ttributes
        file_Ref *pFile,	// OBN OUT, Length=1 : File handle
        char * Path		// OBN IN, Length=256: File extended Path
        );
/*--------------------------------------------------------------------*
                Close
 *--------------------------------------------------------------------*/
#define file_Close(f)	(drv_Close(f,0)) 
/*--------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif
