/*************************************************************************
                        MLOS Configuration
 *************************************************************************
 07/08/2009 Marc LEGOUX V2r24a : Add Process and Quit in mloscfg_Type
 15/04/2009 Marc LEGOUX V2r23p : Add extern "C" block
 *************************************************************************/
#ifndef mloscfg_h
#define mloscfg_h

#ifdef __cplusplus
extern "C" {
#endif

#include "uid/config.h"
#include "err.h"
#if config_WIN
#include <windows.h>
#endif

#define mloscfg_ModeMask0	0		// Parameters up to Options
#define mloscfg_ModeMask	0x10000		// Parameters up to syst_PrintFunc
#define mloscfg_ModeMaskV2r24	0x20000		// Parameters up to Quit

typedef
  struct {
    unsigned long Mode;		// Mode and parameter mask
    char IniPath[256+1]; 	// System .INI file (ex: "C:\\MLOS.INI") or "" 
    				// Other .INI files are assumed to be
    				// in the same directory
    char AppName[32+1];		// Application name or "" 
    
    #if !config_CONSO && config_WIN32
    HWND	syst_PrintWnd;			// 0 or Print window 
    #endif
    
    char * Options;				// 0 or string of Options (0 terminated)
    err_Type (* syst_PrintFunc)(char *);	// 0 or Print function
    
    // From V2r24
    #if config_WIN
    HANDLE Process;
    #else
    ulong  Process;			// 0 or Process instance
    #endif
    err_Type (* Quit)();		// 0 or Process quit
    
  } mloscfg_Type;

/*-----------------------------------------------------------------------*
                        Init specific data 
 *-----------------------------------------------------------------------*/
err_Type mloscfg_Init(
        mloscfg_Type * Cfg	/* (IN): Cfg with default */
	);
/*-----------------------------------------------------------------------*
                        Start the system
 Returns when the system is running (may be not fully ready)
 *-----------------------------------------------------------------------*/
err_Type mloscfg_Start(mloscfg_Type * Cfg);
/*-----------------------------------------------------------------------*
                        End the system
 Returns when the system is stopped
 *-----------------------------------------------------------------------*/
err_Type mloscfg_End(mloscfg_Type * Cfg);

#ifdef __cplusplus
}
#endif
#endif
