/************************************************************************
                        SECUR
                Interface for Security
 ************************************************************************
 Copyright (c) SMARTWARE, 1999, 2002 All Rights Reserved.
 ************************************************************************
 17/05/2002 - Marc LEGOUX - c6r08 : Update
 14/02/2002 - Marc LEGOUX - c6r07 : Creation
 ************************************************************************/
#ifndef secur_h
#define secur_h

#include <err.h>
#include <sysobj.h>
#include <systsi.h>

#ifdef __cplusplus
extern "C" {
#endif
/*----------------------------------------------------------------------*
			Modes
 *----------------------------------------------------------------------*/
#define secur_ModeNoUnsec	0x01		// Unsecure system not allowed
#define secur_ModeSecure	syst_SIModeSecure	// 0 for Unsecure
#define secur_ModeAll		syst_SIModeAll	// Action on all items
#define secur_ModeTask		0x08		// Action on Task
#define secur_ModeGlobal	0x10		// Action on remote station
/*----------------------------------------------------------------------*
			Session ID
 *----------------------------------------------------------------------*/
#define secur_SessionIdType syst_SISessionIdType
/*----------------------------------------------------------------------*
                        Define user
 *----------------------------------------------------------------------*/
extern
err_Type secur_UserDef(
  sysobj_NodeType Node,         // Target Node or 0 for local node
  unsigned Mode,                // Mode
  char * UserName,              // User name (0 terminated, Max 128 bytes)
  uchar * UserPwd,              // User password (Max 256 bytes)
  unsigned UserPwdLen           // Password length
  );
/*----------------------------------------------------------------------*
                        Undefine user
 *----------------------------------------------------------------------*/
extern
err_Type secur_UserUndef(
  sysobj_NodeType Node,         // Target Node or 0 for local node
  unsigned Mode,                // Mode
  char * UserName               // User name (0 terminated, Max 128 bytes)
  );
/*----------------------------------------------------------------------*
                        User Login 
 Usefull Modes :
 secur_ModeNoUnsec
 *----------------------------------------------------------------------*/
extern
err_Type secur_UserLogin(
  sysobj_NodeType Node,         // Target Node or 0 for local node
  unsigned Mode,                // Mode
  char * UserName,              // User name (0 terminated, Max 128 bytes)
  uchar * UserPwd,              // User password (Max 256 bytes)
  unsigned UserPwdLen,          // Password length
  secur_SessionIdType * pSId    // Null or OUT: Session Id
  );
/*----------------------------------------------------------------------*
                        User Logout
 Usefull Modes :
 secur_ModeAll  : User logout for all tasks
 secur_ModeTask	: Task logout for all users
 *----------------------------------------------------------------------*/
extern
err_Type secur_UserLogout(
  sysobj_NodeType Node,         // Target Node or 0 for local node
  unsigned Mode,                // Mode
  char * UserName,              // Null for current or User name (0 terminated)
  secur_SessionIdType * pSId    // Null or OUT: Session Id
  );
/*----------------------------------------------------------------------*
                        Current user Infos
 *----------------------------------------------------------------------*/
extern
err_Type secur_UserInfo(
  sysobj_NodeType Node,         // Target Node or 0 for local node
  unsigned Mode,                // Mode
  uchar * pBuf,                 // OUT: Infos
  unsigned * pMaxL              // IN: Info maximum size, OUT: Returned size
  );
/*----------------------------------------------------------------------*
                        Accredit
 Usefull Modes:
 secur_ModeSecure : Remove, else give accreditation
 secur_ModeAll	  : With ModeTask, on all local tasks
 secur_ModeGlobal : On Node station
 *----------------------------------------------------------------------*/
extern
err_Type secur_Accredit(
  sysobj_NodeType Node,         // Target Node or 0 for local node
  unsigned Mode,                // Mode (Ored flags)
  secur_SessionIdType SId       // Session Id
  );
/*----------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif
