/************************************************************************
			SLBUS
                        Driver interface
 ************************************************************************
 20/10/2005 Marc LEGOUX V2R24  : Add _Config()
 17/12/2003 Marc LEGOUX V1R14  : Creation
 ************************************************************************/
#ifndef slbusu_h
#define slbusu_h

#include <err.h>

#ifdef __cplusplus
extern "C" {
#endif

// OBN Class slbus BEGIN Version=V2R24 Author=MarcLEGOUX
/*----------------------------------------------------------------------*
			Type
 *----------------------------------------------------------------------*/
#define slbus_Type	void
/*----------------------------------------------------------------------*
                        JTAG Open
 *----------------------------------------------------------------------*/
extern
err_Type slbus_JtagOpen(
        slbus_Type * This, 
        unsigned Mode,
        unsigned Fwi
        );
/*----------------------------------------------------------------------*
                        JTAG Close
 *----------------------------------------------------------------------*/
extern
err_Type slbus_JtagClose(
        slbus_Type * This, 
        unsigned Mode
        );
/*----------------------------------------------------------------------*
                        JTAG Clock step
 DI and DO are shifted. The LSBit is the first encountered bit. 
 *----------------------------------------------------------------------*/
extern
err_Type slbus_JtagClockStep(
        slbus_Type * This, 
        unsigned Mode, 	// TMS
        unsigned ClockNb,
        ulong    DI,	// DI
        ulong * pDO	// OBN OUT,Size=1 // DO
        );
/*----------------------------------------------------------------------*
			List of FWIs
 *----------------------------------------------------------------------*/
#pragma pack(1)
typedef
  struct {
    uchar	FwiNum;		// Fwi number 0..15
    uchar	TypeNum;	// Type register value
    uchar	VersNum;	// Version register value
    char	DrvName[33];	// Installer driver name or ""
  } slbus_FwiInfoType;
#if config_DIAB
#pragma pack(0)
#else
#pragma pack()
#endif

extern
err_Type slbus_FwiInfoList(
	slbus_Type * This, 
	unsigned Mode, 
	slbus_FwiInfoType pList[16]	// OBN OUT
);
/*----------------------------------------------------------------------*
                        Bus Config
 Cfg == <Clock divider> << 4 + <Wait states>
 *----------------------------------------------------------------------*/
#define slbus_CfgMaskWaitStates		0x0F	// Wait states
#define slbus_CfgMaskClockDiv		0xF0	// Cpu clock divider

#define slbus_CfgModeWaitStates	1	// Set wait states
#define slbus_CfgModeClockDiv	2	// Set clock divider

extern
err_Type slbus_Config(
        slbus_Type * This, 
        unsigned Mode, 			// bit0=1 : Set a new value
        ulong Cfg,	 		// New value if mode
        ulong pCfg[1]			// OBN OUT : previous value
        );
/*----------------------------------------------------------------------*/
/* OBN Class slbus END */

#ifdef __cplusplus
}
#endif
#endif
