/************************************************************************
                        SYSTSI
                Host System Interface for Security
 		Private to MLOS (not available to users)
 ************************************************************************
 Copyright (c) SMARTWARE, 1999, 2002 All Rights Reserved.
 ************************************************************************
 17/05/2002 - Marc LEGOUX - c6r08 : Update
 14/02/2002 - Marc LEGOUX - c6r07 : Creation
 ************************************************************************/
#ifndef systsi_h
#define systsi_h

#include <err.h>

#ifdef __cplusplus
extern "C" {
#endif
/*----------------------------------------------------------------------*
			Session Id
 *----------------------------------------------------------------------*/
typedef
  ulong syst_SISessionIdType;
/*----------------------------------------------------------------------*
			Modes
 *----------------------------------------------------------------------*/
#define syst_SIModeSecure	2	// 0 for Unsecure
#define syst_SIModeAll		4	// 0 for one
/*----------------------------------------------------------------------*
                        Define user
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIUserDef(
  unsigned Mode,                // Mode (0)
  char * UserName,              // User name (0 terminated, Max 128 bytes)
  uchar * UserPwd,              // User password (Max 256 bytes)
  unsigned UserPwdLen           // Password length
  );
/*----------------------------------------------------------------------*
                        Undefine user
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIUserUndef(
  unsigned Mode,                // Mode (0)
  char * UserName               // User name (0 terminated, Max 128 bytes)
  );
/*----------------------------------------------------------------------*
                        User Login 
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIUserLogin(
  unsigned Mode,                // Mode (0)
  char * UserName,              // User name (0 terminated, Max 128 bytes)
  uchar * UserPwd,              // User password (Max 256 bytes)
  unsigned UserPwdLen,          // Password length
  syst_SISessionIdType * pSId	// Null or IN: 0 or Session Id, OUT: New session Id
  );
/*----------------------------------------------------------------------*
                        Current user Logout
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIUserLogout(
  unsigned Mode,                // Mode (0)
  char * UserName,              // User name (0 terminated, Max 128 bytes)
  syst_SISessionIdType * pSId	// Null or IN: Session Id, OUT: New session Id or 0
  );
/*----------------------------------------------------------------------*
                        Current user Infos
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIUserInfo(
  unsigned Mode,                // Mode (0)
  uchar * pBuf,                 // OUT: Infos
  unsigned * pMaxL              // IN: Info maximum size, OUT: Returned size
  );
/*----------------------------------------------------------------------*
                        Unsecure/Secure system until restart
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIUnsecure(
  unsigned Mode,                // Mode
  syst_SISessionIdType SId      // Session Id
  );
/*----------------------------------------------------------------------*
                        Start
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIStart(
  void * Cfg
  );
/*----------------------------------------------------------------------*
                        End
 *----------------------------------------------------------------------*/
extern
err_Type syst_SIEnd(
  void * Cfg
  );
/*----------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif
