/**********************************************************************
			    HEADER
                   	Terminal TERM
 **********************************************************************
 Copyright (c) SMARTWARE, 1999-2005 All Rights Reserved.
 **********************************************************************
 19/09/2006 Marc LEGOUX V6r22 Add the CS mode
 03/08/2005 Marc LEGOUX V6r19 Add the No Output mode
 20/03/2003 Marc LEGOUX V6r09 Change error base to extern
 19/03/1999 Marc LEGOUX V6r06 Creation
 **********************************************************************/
#ifndef term_h
#define term_h

#include <err.h>
#include <syst.h>
#include <sasy.h>
#include <sysobj.h>
/*-------------------------------------------------------------------*
			ERROR codes
 *-------------------------------------------------------------------*/
extern err_Type term__Err;
#define term__NotOpen	(term__Err + 1)
#define term__Timeout	(term__Err + 2)
#define term__Empty	(term__Err + 3)	// Fifo empty
/*----------------------------------------------------------------------*
                        CONFIGURATION PARAMETERS
 *----------------------------------------------------------------------*/
typedef
  struct {
    ulong magic;		/* Inited if OK */
    char AutoStart;		/* Comm is inited when task starts [1] */
    sasy_CtrlBlk sasy;		/* Line config */
    uchar	Led;		/* Activity led or 0 */
    unsigned	Mode;		/* Mode */
    syst_TType	FullTimeout;	/* Waiting time if fifo full (or 0) */
    uchar	LostChar;	/* Char to send if chars are lost */
    sysobj_ObjType	Id;	/* Term id (0 for default) */
  } term_CfgType;

#define term_CfgModeGet		0x0001	/* With Get task */
#define term_CfgModeLostChar	0x0002	/* Send this char if chars are lost */
#define term_CfgModeNoPut	0x0004	// No output to COM port
#define term_CfgModeOverwrite	0x0008	// Overwrite output if fifo full
#define term_CfgModeCS		0x0010	// Replace Mutex with a critical section
#define term_CfgModeFrozen	0x0020	// Out fifo is frozen

// term_CfgModeCS => NoPut | Overwrite
/*----------------------------------------------------------------------*
                        OBJECT
 *----------------------------------------------------------------------*/
#define term_Type void *
/*----------------------------------------------------------------------*
                        Config INIT
 [re]Init basic communication
 If object is started: waits for reinit is over
 *----------------------------------------------------------------------*/
extern
err_Type term_CfgInit(
        term_Type * Obj, 
        term_CfgType * Cfg
        );
/*----------------------------------------------------------------------*
                        OBJECT START
 *----------------------------------------------------------------------*/
extern
err_Type term_ObjNew(
        sysobj_ObjType id,	/* Object id */
        term_Type ** pObj,	/* (OUT): Object context */
        void * Param
        );
/*----------------------------------------------------------------------*
                        Put buffer
 *----------------------------------------------------------------------*/
extern
err_Type term_PutBuf(
        term_Type * Obj,
        uchar * pbuf,		/* Buffer */
        unsigned * pl		/* (IN): length to put, (OUT): length not put */
        );
/*----------------------------------------------------------------------*
                        Put string
 *----------------------------------------------------------------------*/
extern
err_Type term_PutSt(
        term_Type * Obj,
        char * st
        );
/*----------------------------------------------------------------------*
			Get
 String Mode : 
   Returns as soon as a char is : 
   00 : included
   LF : included and 0 is appended
   CR : ignored except in ModeCR where it is changed to LF
 *----------------------------------------------------------------------*/
#define term_GetModeString	1	/* String ended with 0 */
#define term_GetModeDrain	2	/* Drain First */
#define term_GetModeCR		4	/* Do not ignore CR (string mode)*/

extern
err_Type term_Get(
        term_Type * Obj,
        uchar * pbuf,		/* Buffer */
        unsigned *prespl,	/* (IN) length to get, (OUT) returned length */
        uchar mode,		/* Mode */
        syst_TType timeout
        );
/*-----------------------------------------------------------------------*
                        Start Module
 *-----------------------------------------------------------------------*/
extern
err_Type term_Start(
        void * Cfg
        );
/*-----------------------------------------------------------------------*
                        End Module
 *-----------------------------------------------------------------------*/
extern
err_Type term_Start(
        void * Cfg
        );
/*---------------------------------------------------------------------*/
#endif
