/************************************************************************
			ERR
			Basic Error Codes
 ************************************************************************
 20/10/2009 - Marc LEGOUX - C6r24 : Add usb__Err
 01/09/2008 - Marc LEGOUX - C6r23 : Add slbus and mbus
 12/09/2007 - Marc LEGOUX - C6r22 : Remove CARD Errors
 06/10/2005 - Marc LEGOUX - C6r21 : Update with ecom
 12/07/2005 - Marc LEGOUX - C6r18 : Update with err_WinBase
 09/03/2005 - Marc LEGOUX - C6r18 : Add epc__Err
 17/08/2003 - Marc LEGOUX - C6r09 : Add hwi__SerialErr
 18/03/2003 - Marc LEGOUX - C6r09 : Add ip__NGErr
 17/12/2002 - Marc LEGOUX - C6r07 : Add ipnet__Err, ngnet__Err
 25/10/2002 - Marc LEGOUX - C6r07 : Add pac__Err
 10/10/2001 - Marc LEGOUX - C6r07 : Add userlist__Err
 25/04/2000 - Marc LEGOUX - C6r03 : Add log__Err
 16/03/2000 - Marc LEGOUX - C6r03 : Move syst__Err 10400->30000
 			    Add  syst__ExitErr
 16/01/2000 - Marc LEGOUX - C6r02 : Extract from ERR
 ************************************************************************/
#include <err.h>

/*---------------------------------------------------------------------*
                      ASSIGNMENT of ERROR CODE BASES
 
 Each module Owns at least a slice of 100 error codes
 First 256 codes are reserved for system and one byte error codes.
 
 NOTE: For WinNT compatibility, the bit 29 of application error codes 
 is set to 1, so WinNT and application error codes could be mixed.
 *----------------------------------------------------------------------*/

/* base 0 is reserved for 8bits system error codes */
#ifndef sys__err
err_Type sys__err	= 0;
#endif
#ifndef sys__ok
err_Type sys__ok	= 0;
#endif
#if config_COMPILER==MSC
// for old entry points in .DEF
err_Type sys__Dummy1	= 0;
err_Type sys__Dummy2	= 0;
err_Type sys__Dummy3	= 0;
err_Type sys__Dummy4	= 0;
err_Type sys__Dummy5	= 0;
#endif

// ***** 1..255 : Reserved for sysobj objects: 8 codes per object

err_Type config__err	= 300;
err_Type phmem_err	= 350;
err_Type mem__err	= 350;
err_Type exc__err	= 400;
err_Type char__err	= 500;

err_Type objdl__err	= 550;
err_Type hex__err	= 590;

err_Type sasy__err	= 600;	/* from 632, error from asynch*/
err_Type hwi__SerialErr	= 600;	// same as sasy
err_Type dop__err	= 700;
err_Type rdc__err	= 700;
err_Type tm__err	= 800;

err_Type ecp__err	= 900;

err_Type file__err	= 1000;
err_Type syst__FileErr	= 1000;
err_Type txf__err	= 1100;
err_Type systwin__err	= 1200;

err_Type modem__err	= 1500;

err_Type date__err	= 2000;

err_Type parse__err	= 5000;
err_Type tcur__err	= 5050;
err_Type macro_err	= 5080;
err_Type rci__err	= 5100;

//err_Type carte__err	= 5200;
//err_Type card__err	= 5200;

err_Type test__err	= 5300;
err_Type flow__err	= 5400;
err_Type env__err	= 5450;
err_Type tcur__ObjErr	= 5500;
err_Type dbgob__Err	= 5600;
//err_Type xmlparse__Err	= 5650;

// MLOS32
err_Type task__Err	= 9000;
err_Type timer__Err	= 9020;
err_Type event__Err	= 9030;
err_Type itere__Err	= 9030;

// MLL objects
err_Type obj__err	= 10000;
err_Type name__err	= 10090;
err_Type iter__err	= 10100;
err_Type list__err	= 10100;	/* Same to got same code iter__end */
err_Type listxt__err	= 10200;
err_Type sql__err	= 10300;
err_Type cfg__Err	= 10500;
err_Type net8b__err	= 10600;
err_Type dcom__Err	= 10600;
err_Type filob__Err	= 10700;
err_Type intob__err	= 10800;
err_Type stob__err	= 10900;
//err_Type xmlob__Err	= 10950;

err_Type membuf__Err	= 11000;

/* Network */
err_Type netob__Err	= 12000;
err_Type netobj__Err	= 12000;

// 3d
err_Type obj3d__Err	= 13000;

/* Application generator */
err_Type vf_err		= 14000;
err_Type ctf_err	= 14020;
err_Type cf_err		= 14050;
err_Type import__err	= 14070;

/* High level objects */
err_Type query__err	= 15000;
err_Type certif__Err	= 16000;

err_Type listobj__Err	= 20000;
err_Type editwin__err	= 20020;

err_Type term__Err	= 20200;
err_Type log__Err	= 20250;
err_Type fifo__Err	= 20300;
err_Type fifom__Err	= 20310;
err_Type chrono__Err	= 20320;
err_Type udp__Err	= 20450;
err_Type buffer__Err	= 20500;
err_Type pool__Err	= 20520;
err_Type ip__Err	= 20550;
err_Type dm9008__err	= 20600;
err_Type ipnet__Err	= 20620;

err_Type ngnet__Err	= 20640;	// obsolete
err_Type ip__NGErr	= 20640;

err_Type hwi__MemErr	= 21000;
err_Type hwi__ComBErr	= 21020;
err_Type hwi__DmaErr	= 21100;

//err_Type cartob__err	= 21500;
//err_Type cardob__Err	= 21500;

// ***** 25000 [+2000] reserved for Smart Card Interfaces
//err_Type ecom__Err	= 25900;
// *****

err_Type drv__Err	= 27000;
err_Type pac__Err	= 28000;

err_Type syst__Err	= 30000;	// Previously 10400
err_Type syst__SocketErr= 30400;	// Previously 20400
err_Type socket__Err	= 30400;

//err_Type syst__WinErr	= 30500;	// 30500..30599

err_Type user__ListErr	= 30600;
err_Type userlist__Err	= 30600;

err_Type syst__ExitErr	= 40000;	// first codes=errorlevel

err_Type slbus__ComErr	= 91000;
err_Type slbus__Err	= 91020;
err_Type mbus__Err	= 91030;

// 100000 - 199000 reserved for external packges

err_Type stapl__Err	= 100100;
err_Type epc__Err	= 100200;

err_Type erwan__Err	= 101000;

err_Type usb__Err	= 105000;	// 1000

// 200000 - 299999 reserved for user applications
// 290000 - 299999 reserved for DC customer applications

#if config_WIN
err_Type win__Err	= err_WinBase;
#endif

